/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.booter.spi;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.maven.shadefire.surefire.api.booter.MasterProcessChannelDecoder;
import org.apache.maven.shadefire.surefire.api.booter.MasterProcessChannelEncoder;
import org.apache.maven.shadefire.surefire.api.fork.ForkNodeArguments;
import org.apache.maven.shadefire.surefire.api.util.internal.Channels;
import org.apache.maven.shadefire.surefire.api.util.internal.DaemonThreadFactory;
import org.apache.maven.shadefire.surefire.api.util.internal.WritableBufferedByteChannel;
import org.apache.maven.shadefire.surefire.booter.spi.AbstractMasterProcessChannelProcessorFactory;
import org.apache.maven.shadefire.surefire.booter.spi.CommandChannelDecoder;
import org.apache.maven.shadefire.surefire.booter.spi.EventChannelEncoder;

public class SurefireMasterProcessChannelProcessorFactory
extends AbstractMasterProcessChannelProcessorFactory {
    private static final int FLUSH_PERIOD_MILLIS = 100;
    private volatile AsynchronousSocketChannel clientSocketChannel;

    @Override
    public boolean canUse(String channelConfig) {
        return channelConfig.startsWith("tcp://");
    }

    @Override
    public void connect(String channelConfig) throws IOException {
        if (!this.canUse(channelConfig)) {
            throw new MalformedURLException("Unknown channel string " + channelConfig);
        }
        try {
            URI uri = new URI(channelConfig);
            InetSocketAddress hostAddress = new InetSocketAddress(uri.getHost(), uri.getPort());
            this.clientSocketChannel = AsynchronousSocketChannel.open(AsynchronousChannelGroup.withFixedThreadPool(2, DaemonThreadFactory.newDaemonThreadFactory()));
            this.setTrueOptions(StandardSocketOptions.SO_REUSEADDR, StandardSocketOptions.TCP_NODELAY, StandardSocketOptions.SO_KEEPALIVE);
            this.clientSocketChannel.connect(hostAddress).get();
            String sessionId = SurefireMasterProcessChannelProcessorFactory.extractSessionId(uri);
            if (sessionId != null) {
                ByteBuffer buff = ByteBuffer.wrap(sessionId.getBytes(StandardCharsets.US_ASCII));
                while (buff.hasRemaining()) {
                    this.clientSocketChannel.write(buff).get();
                }
            }
        }
        catch (InterruptedException | URISyntaxException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getLocalizedMessage(), e.getCause());
        }
    }

    @Override
    public MasterProcessChannelDecoder createDecoder(@Nonnull ForkNodeArguments forkingArguments) {
        ReadableByteChannel bufferedChannel = Channels.newBufferedChannel(Channels.newInputStream(this.clientSocketChannel));
        return new CommandChannelDecoder(bufferedChannel, forkingArguments);
    }

    @Override
    public MasterProcessChannelEncoder createEncoder(@Nonnull ForkNodeArguments forkingArguments) {
        WritableBufferedByteChannel channel = Channels.newBufferedChannel(Channels.newOutputStream(this.clientSocketChannel));
        this.schedulePeriodicFlusher(100, channel);
        return new EventChannelEncoder(channel);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.clientSocketChannel != null && this.clientSocketChannel.isOpen()) {
            this.clientSocketChannel.close();
        }
    }

    @SafeVarargs
    private final void setTrueOptions(SocketOption<Boolean> ... options) throws IOException {
        for (SocketOption<Boolean> option : options) {
            if (!this.clientSocketChannel.supportedOptions().contains(option)) continue;
            this.clientSocketChannel.setOption((SocketOption)option, (Object)true);
        }
    }

    private static String extractSessionId(URI uri) {
        String query = uri.getQuery();
        if (query == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(query, "&");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int delimiter = token.indexOf(61);
            if (delimiter == -1 || !"sessionId".equals(token.substring(0, delimiter))) continue;
            return token.substring(delimiter + 1);
        }
        return null;
    }
}

