/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.shared.utils.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import org.apache.maven.shadefire.surefire.shared.utils.cli.AbstractStreamHandler;
import org.apache.maven.shadefire.surefire.shared.utils.cli.StreamConsumer;

public class StreamPumper
extends AbstractStreamHandler {
    private final BufferedReader in;
    private final StreamConsumer consumer;
    private volatile Exception exception = null;
    private static final int SIZE = 1024;

    public StreamPumper(InputStream in, StreamConsumer consumer) {
        this(new InputStreamReader(in), consumer);
    }

    public StreamPumper(InputStream in, StreamConsumer consumer, @Nullable Charset charset) {
        this(null == charset ? new InputStreamReader(in) : new InputStreamReader(in, charset), consumer);
    }

    private StreamPumper(Reader in, StreamConsumer consumer) {
        this.in = new BufferedReader(in, 1024);
        this.consumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String line = this.in.readLine();
            while (line != null) {
                try {
                    if (this.exception == null) {
                        this.consumeLine(line);
                    }
                }
                catch (Exception t) {
                    this.exception = t;
                }
                line = this.in.readLine();
            }
        }
        catch (IOException e) {
            this.exception = e;
        }
        finally {
            block25: {
                try {
                    this.in.close();
                }
                catch (IOException e2) {
                    if (this.exception != null) break block25;
                    this.exception = e2;
                }
            }
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.setDone();
                this.notifyAll();
            }
        }
    }

    @Deprecated
    public void flush() {
    }

    @Deprecated
    public void close() {
    }

    public Exception getException() {
        return this.exception;
    }

    private void consumeLine(String line) throws IOException {
        if (this.consumer != null && !this.isDisabled()) {
            this.consumer.consumeLine(line);
        }
    }
}

