/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.shared.io.build;

import java.nio.charset.Charset;
import org.apache.maven.shadefire.surefire.shared.io.Charsets;
import org.apache.maven.shadefire.surefire.shared.io.build.AbstractOriginSupplier;

public abstract class AbstractStreamBuilder<T, B extends AbstractStreamBuilder<T, B>>
extends AbstractOriginSupplier<T, B> {
    private int bufferSize = 8192;
    private int bufferSizeDefault = 8192;
    private Charset charset = Charset.defaultCharset();
    private Charset charsetDefault = Charset.defaultCharset();

    protected int getBufferSize() {
        return this.bufferSize;
    }

    protected int getBufferSizeDefault() {
        return this.bufferSizeDefault;
    }

    protected Charset getCharset() {
        return this.charset;
    }

    protected Charset getCharsetDefault() {
        return this.charsetDefault;
    }

    public B setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize >= 0 ? bufferSize : this.bufferSizeDefault;
        return (B)((AbstractStreamBuilder)this.asThis());
    }

    public B setBufferSize(Integer bufferSize) {
        this.setBufferSize(bufferSize != null ? bufferSize : this.bufferSizeDefault);
        return (B)((AbstractStreamBuilder)this.asThis());
    }

    protected B setBufferSizeDefault(int bufferSizeDefault) {
        this.bufferSizeDefault = bufferSizeDefault;
        return (B)((AbstractStreamBuilder)this.asThis());
    }

    public B setCharset(Charset charset) {
        this.charset = Charsets.toCharset(charset, this.charsetDefault);
        return (B)((AbstractStreamBuilder)this.asThis());
    }

    public B setCharset(String charset) {
        return this.setCharset(Charsets.toCharset(charset, this.charsetDefault));
    }

    protected B setCharsetDefault(Charset defaultCharset) {
        this.charsetDefault = defaultCharset;
        return (B)((AbstractStreamBuilder)this.asThis());
    }
}

