/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.api.booter;

import java.util.Objects;
import org.apache.maven.shadefire.surefire.api.booter.MasterProcessCommand;
import org.apache.maven.shadefire.surefire.api.booter.Shutdown;
import org.apache.maven.shadefire.surefire.shared.utils.StringUtils;

public final class Command {
    public static final Command TEST_SET_FINISHED = new Command(MasterProcessCommand.TEST_SET_FINISHED);
    public static final Command SKIP_SINCE_NEXT_TEST = new Command(MasterProcessCommand.SKIP_SINCE_NEXT_TEST);
    public static final Command NOOP = new Command(MasterProcessCommand.NOOP);
    public static final Command BYE_ACK = new Command(MasterProcessCommand.BYE_ACK);
    private final MasterProcessCommand command;
    private final String data;

    public Command(MasterProcessCommand command, String data) {
        this.command = Objects.requireNonNull(command);
        this.data = data;
    }

    public Command(MasterProcessCommand command) {
        this(command, null);
    }

    public static Command toShutdown(Shutdown shutdownType) {
        return new Command(MasterProcessCommand.SHUTDOWN, shutdownType.name());
    }

    public static Command toRunClass(String runClass) {
        return new Command(MasterProcessCommand.RUN_CLASS, runClass);
    }

    public MasterProcessCommand getCommandType() {
        return this.command;
    }

    public String getData() {
        return this.data;
    }

    public Shutdown toShutdownData() {
        if (this.command != MasterProcessCommand.SHUTDOWN) {
            throw new IllegalStateException("expected MasterProcessCommand.SHUTDOWN");
        }
        return StringUtils.isBlank(this.data) ? Shutdown.DEFAULT : Shutdown.valueOf(this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Command arg = (Command)o;
        return this.command == arg.command && Objects.equals(this.data, arg.data);
    }

    public int hashCode() {
        int result = this.command.hashCode();
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        return result;
    }
}

