/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.api.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.shadefire.surefire.api.testset.TestSetFailedException;
import org.apache.maven.shadefire.surefire.api.util.CloseableIterator;

public class TestsToRun
implements Iterable<Class<?>> {
    private final List<Class<?>> locatedClasses;
    private volatile boolean finished;
    private int iteratedCount;

    public TestsToRun(Set<Class<?>> locatedClasses) {
        this.locatedClasses = new ArrayList(locatedClasses);
    }

    public static TestsToRun fromClass(Class<?> clazz) throws TestSetFailedException {
        return new TestsToRun(Collections.singleton(clazz));
    }

    public Iterator<Class<?>> iterated() {
        return this.newWeakIterator();
    }

    @Override
    public Iterator<Class<?>> iterator() {
        return new ClassesIterator();
    }

    public final void markTestSetFinished() {
        this.finished = true;
    }

    public final boolean isFinished() {
        return this.finished;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TestsToRun: [");
        for (Class<?> clazz : this) {
            sb.append(' ').append(clazz.getName());
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean containsAtLeast(int atLeast) {
        return this.containsAtLeast(this.iterator(), atLeast);
    }

    private boolean containsAtLeast(Iterator<Class<?>> it, int atLeast) {
        for (int i = 0; i < atLeast; ++i) {
            if (!it.hasNext()) {
                return false;
            }
            it.next();
        }
        return true;
    }

    public boolean containsExactly(int items) {
        Iterator<Class<?>> it = this.iterator();
        return this.containsAtLeast(it, items) && !it.hasNext();
    }

    public boolean allowEagerReading() {
        return true;
    }

    public Class<?>[] getLocatedClasses() {
        if (!this.allowEagerReading()) {
            throw new IllegalStateException("Cannot eagerly read");
        }
        ArrayList result = new ArrayList();
        for (Class<?> clazz : this) {
            result.add(clazz);
        }
        return result.toArray(new Class[result.size()]);
    }

    public Class<?> getClassByName(String className) {
        for (Class<?> clazz : this) {
            if (!clazz.getName().equals(className)) continue;
            return clazz;
        }
        return null;
    }

    private Iterator<Class<?>> newWeakIterator() {
        final Iterator<Class<?>> it = this.locatedClasses.subList(0, this.iteratedCount).iterator();
        return new CloseableIterator<Class<?>>(){

            @Override
            protected boolean isClosed() {
                return TestsToRun.this.isFinished();
            }

            @Override
            protected boolean doHasNext() {
                return it.hasNext();
            }

            @Override
            protected Class<?> doNext() {
                return (Class)it.next();
            }

            @Override
            protected void doRemove() {
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("unsupported remove");
            }
        };
    }

    private final class ClassesIterator
    extends CloseableIterator<Class<?>> {
        private final Iterator<Class<?>> it;
        private int iteratedCount;

        private ClassesIterator() {
            this.it = TestsToRun.this.locatedClasses.iterator();
        }

        @Override
        protected boolean isClosed() {
            return TestsToRun.this.isFinished();
        }

        @Override
        protected boolean doHasNext() {
            return this.it.hasNext();
        }

        @Override
        protected Class<?> doNext() {
            Class<?> nextTest = this.it.next();
            TestsToRun.this.iteratedCount = Math.max(++this.iteratedCount, TestsToRun.this.iteratedCount);
            return nextTest;
        }

        @Override
        protected void doRemove() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("unsupported remove");
        }
    }
}

