/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.common.junit3;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Test;
import org.apache.maven.shadefire.surefire.api.filter.NonAbstractClassFilter;
import org.apache.maven.shadefire.surefire.api.util.ReflectionUtils;
import org.apache.maven.shadefire.surefire.api.util.ScannerFilter;

public class JUnit3TestChecker
implements ScannerFilter {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private final Class<?> junitClass;
    private final NonAbstractClassFilter nonAbstractClassFilter = new NonAbstractClassFilter();

    public JUnit3TestChecker(ClassLoader testClassLoader) {
        this.junitClass = ReflectionUtils.tryLoadClass(testClassLoader, "junit.framework.Test");
    }

    @Override
    public boolean accept(Class testClass) {
        return this.nonAbstractClassFilter.accept(testClass) && this.isValidJUnit3Test(testClass);
    }

    private boolean isValidJUnit3Test(Class<?> testClass) {
        return this.junitClass != null && (this.junitClass.isAssignableFrom(testClass) || this.isSuiteOnly(testClass));
    }

    private boolean isSuiteOnly(Class testClass) {
        int modifiers;
        Method suite = ReflectionUtils.tryGetMethod(testClass, "suite", EMPTY_CLASS_ARRAY);
        if (suite != null && Modifier.isPublic(modifiers = suite.getModifiers()) && Modifier.isStatic(modifiers)) {
            return Test.class.isAssignableFrom(suite.getReturnType());
        }
        return false;
    }
}

