/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.api.report;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.maven.shadefire.surefire.api.report.RunMode;
import org.apache.maven.shadefire.surefire.api.report.SimpleReportEntry;
import org.apache.maven.shadefire.surefire.api.report.StackTraceWriter;
import org.apache.maven.shadefire.surefire.api.report.TestSetReportEntry;

public class CategorizedReportEntry
extends SimpleReportEntry {
    public static final String GROUP_PREFIX = " (of ";
    private static final String GROUP_SUFIX = ")";
    private final String group;

    public CategorizedReportEntry(@Nonnull RunMode runMode, @Nonnegative Long testRunId, String source, String name, String group) {
        this(runMode, testRunId, source, name, group, (StackTraceWriter)null, (Integer)null);
    }

    public CategorizedReportEntry(@Nonnull RunMode runMode, @Nonnegative Long testRunId, String source, String name, String group, StackTraceWriter stackTraceWriter, Integer elapsed) {
        super(runMode, testRunId, source, null, name, null, stackTraceWriter, elapsed);
        this.group = group;
    }

    public CategorizedReportEntry(@Nonnull RunMode runMode, @Nonnegative Long testRunId, String source, String name, String group, StackTraceWriter stackTraceWriter, Integer elapsed, String message) {
        this(runMode, testRunId, source, null, name, null, group, stackTraceWriter, elapsed, message, Collections.emptyMap());
    }

    public CategorizedReportEntry(@Nonnull RunMode runMode, @Nonnegative Long testRunId, String source, String sourceText, String name, String nameText, String group, StackTraceWriter stackTraceWriter, Integer elapsed, String message, Map<String, String> systemProperties) {
        super(runMode, testRunId, source, sourceText, name, nameText, stackTraceWriter, elapsed, message, systemProperties);
        this.group = group;
    }

    public static TestSetReportEntry reportEntry(@Nonnull RunMode runMode, @Nonnegative Long testRunId, String source, String sourceText, String name, String nameText, String group, StackTraceWriter stackTraceWriter, Integer elapsed, String message, Map<String, String> systemProperties) {
        return group != null ? new CategorizedReportEntry(runMode, testRunId, source, sourceText, name, nameText, group, stackTraceWriter, elapsed, message, systemProperties) : new SimpleReportEntry(runMode, testRunId, source, sourceText, name, nameText, stackTraceWriter, elapsed, message, systemProperties);
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getNameWithGroup() {
        return this.isNameWithGroup() ? this.getSourceName() + GROUP_PREFIX + this.getGroup() + GROUP_SUFIX : this.getSourceName();
    }

    @Override
    public String getReportNameWithGroup() {
        return this.isNameWithGroup() ? this.getSourceText() + GROUP_PREFIX + this.getGroup() + GROUP_SUFIX : this.getSourceText();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CategorizedReportEntry that = (CategorizedReportEntry)o;
        return Objects.equals(this.group, that.group);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        return result;
    }

    private boolean isNameWithGroup() {
        return this.getGroup() != null && !this.getGroup().equals(this.getSourceName());
    }
}

