/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.booter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.shadefire.surefire.util.ReflectionUtils;

public final class TypeEncodedValue {
    private final String type;
    private final String value;

    public TypeEncodedValue(String type, String value) {
        this.type = type;
        this.value = value;
    }

    private boolean isTypeClass() {
        return Class.class.getName().equals(this.type);
    }

    public Object getDecodedValue() {
        return this.getDecodedValue(Thread.currentThread().getContextClassLoader());
    }

    public Object getDecodedValue(ClassLoader classLoader) {
        if (this.type.trim().isEmpty()) {
            return null;
        }
        if (this.type.equals(String.class.getName())) {
            return this.value;
        }
        if (this.isTypeClass()) {
            return ReflectionUtils.loadClass(classLoader, this.value);
        }
        if (this.type.equals(File.class.getName())) {
            return new File(this.value);
        }
        if (this.type.equals(Boolean.class.getName())) {
            return Boolean.valueOf(this.value);
        }
        if (this.type.equals(Integer.class.getName())) {
            return Integer.valueOf(this.value);
        }
        if (this.type.equals(Properties.class.getName())) {
            Properties result = new Properties();
            try {
                result.load(new ByteArrayInputStream(this.value.getBytes(StandardCharsets.ISO_8859_1)));
                return result;
            }
            catch (IOException e) {
                throw new IllegalStateException("bug in property conversion", e);
            }
        }
        throw new IllegalArgumentException("Unknown parameter type: " + this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeEncodedValue that = (TypeEncodedValue)o;
        return this.equalsType(that) && this.equalsValue(that);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TypeEncodedValue{type='" + this.type + '\'' + ", value='" + this.value + '\'' + '}';
    }

    private boolean equalsType(TypeEncodedValue that) {
        return Objects.equals(this.type, that.type);
    }

    private boolean equalsValue(TypeEncodedValue that) {
        return Objects.equals(this.value, that.value);
    }
}

