/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.booter;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Queue;
import java.util.Scanner;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.maven.shadefire.surefire.booter.DumpErrorSingleton;
import org.apache.maven.shadefire.surefire.booter.ProcessInfo;
import org.apache.maven.shadefire.surefire.shade.booter.org.apache.commons.io.IOUtils;
import org.apache.maven.shadefire.surefire.shade.booter.org.apache.commons.lang3.SystemUtils;
import org.apache.maven.shadefire.surefire.util.internal.StringUtils;

final class PpidChecker {
    private static final int MINUTES_TO_MILLIS = 60000;
    private static final int WMIC_CREATION_DATE_VALUE_LENGTH = 25;
    private static final int WMIC_CREATION_DATE_TIMESTAMP_LENGTH = 18;
    private static final SimpleDateFormat WMIC_CREATION_DATE_FORMAT = SystemUtils.IS_OS_WINDOWS ? PpidChecker.createWindowsCreationDateFormat() : null;
    private static final String WMIC_CREATION_DATE = "CreationDate";
    private static final String WINDOWS_SYSTEM_ROOT_ENV = "SystemRoot";
    private static final String RELATIVE_PATH_TO_WMIC = "System32\\Wbem";
    private static final String SYSTEM_PATH_TO_WMIC = "%SystemRoot%\\System32\\Wbem\\";
    private static final String PS_ETIME_HEADER = "ELAPSED";
    private static final String PS_PID_HEADER = "PID";
    private final Queue<Process> destroyableCommands = new ConcurrentLinkedQueue<Process>();
    static final Pattern UNIX_CMD_OUT_PATTERN = Pattern.compile("^(((\\d+)-)?(\\d{1,2}):)?(\\d{1,2}):(\\d{1,2})\\s+(\\d+)$");
    static final Pattern BUSYBOX_CMD_OUT_PATTERN = Pattern.compile("^(\\d+)[hH](\\d{1,2})\\s+(\\d+)$");
    private final String ppid;
    private volatile ProcessInfo parentProcessInfo;
    private volatile boolean stopped;

    PpidChecker(@Nonnull String ppid) {
        this.ppid = ppid;
    }

    boolean canUse() {
        if (this.isStopped()) {
            return false;
        }
        ProcessInfo ppi = this.parentProcessInfo;
        return ppi == null ? SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_UNIX && PpidChecker.canExecuteUnixPs() : ppi.canUse();
    }

    boolean isProcessAlive() {
        if (!this.canUse()) {
            throw new IllegalStateException("irrelevant to call isProcessAlive()");
        }
        ProcessInfo previousInfo = this.parentProcessInfo;
        if (SystemUtils.IS_OS_WINDOWS) {
            this.parentProcessInfo = this.windows();
            this.checkProcessInfo();
            return !this.parentProcessInfo.isInvalid() && (previousInfo == null || this.parentProcessInfo.isTimeEqualTo(previousInfo));
        }
        if (SystemUtils.IS_OS_UNIX) {
            this.parentProcessInfo = this.unix();
            this.checkProcessInfo();
            return !this.parentProcessInfo.isInvalid() && (previousInfo == null || !this.parentProcessInfo.isTimeBefore(previousInfo));
        }
        this.parentProcessInfo = ProcessInfo.ERR_PROCESS_INFO;
        throw new IllegalStateException("unknown platform or you did not call canUse() before isProcessAlive()");
    }

    private void checkProcessInfo() {
        if (this.isStopped()) {
            throw new IllegalStateException("error [STOPPED] to read process " + this.ppid);
        }
        if (!this.parentProcessInfo.canUse()) {
            throw new IllegalStateException("Cannot use PPID " + this.ppid + " process information. Going to use NOOP events.");
        }
    }

    ProcessInfo unix() {
        ProcessInfoConsumer reader = new ProcessInfoConsumer(Charset.defaultCharset().name()){

            @Override
            @Nonnull
            ProcessInfo consumeLine(String line, ProcessInfo previousOutputLine) {
                if (previousOutputLine.isInvalid()) {
                    if (this.hasHeader) {
                        Matcher matcher = UNIX_CMD_OUT_PATTERN.matcher(line);
                        if (matcher.matches() && PpidChecker.this.ppid.equals(PpidChecker.fromPID(matcher))) {
                            long pidUptime = PpidChecker.fromDays(matcher) + PpidChecker.fromHours(matcher) + PpidChecker.fromMinutes(matcher) + PpidChecker.fromSeconds(matcher);
                            return ProcessInfo.unixProcessInfo(PpidChecker.this.ppid, pidUptime);
                        }
                        matcher = BUSYBOX_CMD_OUT_PATTERN.matcher(line);
                        if (matcher.matches() && PpidChecker.this.ppid.equals(PpidChecker.fromBusyboxPID(matcher))) {
                            long pidUptime = PpidChecker.fromBusyboxHours(matcher) + PpidChecker.fromBusyboxMinutes(matcher);
                            return ProcessInfo.unixProcessInfo(PpidChecker.this.ppid, pidUptime);
                        }
                    } else {
                        this.hasHeader = line.contains(PpidChecker.PS_ETIME_HEADER) && line.contains(PpidChecker.PS_PID_HEADER);
                    }
                }
                return previousOutputLine;
            }
        };
        String cmd = PpidChecker.unixPathToPS() + " -o etime,pid " + (SystemUtils.IS_OS_LINUX ? "" : "-p ") + this.ppid;
        return reader.execute("/bin/sh", "-c", cmd);
    }

    ProcessInfo windows() {
        ProcessInfoConsumer reader = new ProcessInfoConsumer("US-ASCII"){

            @Override
            @Nonnull
            ProcessInfo consumeLine(String line, ProcessInfo previousProcessInfo) throws Exception {
                if (previousProcessInfo.isInvalid() && !line.isEmpty()) {
                    if (this.hasHeader) {
                        if (line.length() != 25) {
                            throw new IllegalStateException("WMIC CreationDate should have 25 characters " + line);
                        }
                        String startTimestamp = line.substring(0, 18);
                        int indexOfTimeZone = 21;
                        long startTimestampMillisUTC = WMIC_CREATION_DATE_FORMAT.parse(startTimestamp).getTime() - (long)(Integer.parseInt(line.substring(indexOfTimeZone)) * 60000);
                        return ProcessInfo.windowsProcessInfo(PpidChecker.this.ppid, startTimestampMillisUTC);
                    }
                    this.hasHeader = PpidChecker.WMIC_CREATION_DATE.equals(line);
                }
                return previousProcessInfo;
            }
        };
        String wmicPath = PpidChecker.hasWmicStandardSystemPath() ? SYSTEM_PATH_TO_WMIC : "";
        return reader.execute("CMD", "/A", "/X", "/C", wmicPath + "wmic process where (ProcessId=" + this.ppid + ") get " + WMIC_CREATION_DATE);
    }

    void destroyActiveCommands() {
        this.stopped = true;
        Process p = this.destroyableCommands.poll();
        while (p != null) {
            p.destroy();
            p = this.destroyableCommands.poll();
        }
    }

    private boolean isStopped() {
        return this.stopped;
    }

    private static String unixPathToPS() {
        return PpidChecker.canExecuteLocalUnixPs() ? "/usr/bin/ps" : "/bin/ps";
    }

    static boolean canExecuteUnixPs() {
        return PpidChecker.canExecuteLocalUnixPs() || PpidChecker.canExecuteStandardUnixPs();
    }

    private static boolean canExecuteLocalUnixPs() {
        try {
            return new File("/usr/bin/ps").canExecute();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static boolean canExecuteStandardUnixPs() {
        try {
            return new File("/bin/ps").canExecute();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static boolean hasWmicStandardSystemPath() {
        String systemRoot = System.getenv(WINDOWS_SYSTEM_ROOT_ENV);
        return org.apache.maven.shadefire.surefire.shade.booter.org.apache.commons.lang3.StringUtils.isNotBlank(systemRoot) && new File(systemRoot, "System32\\Wbem\\wmic.exe").isFile();
    }

    static long fromDays(Matcher matcher) {
        String s = matcher.group(3);
        return s == null ? 0L : TimeUnit.DAYS.toSeconds(Long.parseLong(s));
    }

    static long fromHours(Matcher matcher) {
        String s = matcher.group(4);
        return s == null ? 0L : TimeUnit.HOURS.toSeconds(Long.parseLong(s));
    }

    static long fromMinutes(Matcher matcher) {
        String s = matcher.group(5);
        return s == null ? 0L : TimeUnit.MINUTES.toSeconds(Long.parseLong(s));
    }

    static long fromSeconds(Matcher matcher) {
        String s = matcher.group(6);
        return s == null ? 0L : Long.parseLong(s);
    }

    static String fromPID(Matcher matcher) {
        return matcher.group(7);
    }

    static long fromBusyboxHours(Matcher matcher) {
        String s = matcher.group(1);
        return s == null ? 0L : TimeUnit.HOURS.toSeconds(Long.parseLong(s));
    }

    static long fromBusyboxMinutes(Matcher matcher) {
        String s = matcher.group(2);
        return s == null ? 0L : TimeUnit.MINUTES.toSeconds(Long.parseLong(s));
    }

    static String fromBusyboxPID(Matcher matcher) {
        return matcher.group(3);
    }

    private static void checkValid(Scanner scanner) throws IOException {
        IOException exception = scanner.ioException();
        if (exception != null) {
            throw exception;
        }
    }

    private static SimpleDateFormat createWindowsCreationDateFormat() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss'.'SSS");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter;
    }

    public void stop() {
        this.stopped = true;
    }

    public String toString() {
        String args = "ppid=" + this.ppid + ", stopped=" + this.stopped;
        ProcessInfo processInfo = this.parentProcessInfo;
        if (processInfo != null) {
            args = args + ", invalid=" + processInfo.isInvalid() + ", error=" + processInfo.isError();
        }
        if (SystemUtils.IS_OS_UNIX) {
            args = args + ", canExecuteLocalUnixPs=" + PpidChecker.canExecuteLocalUnixPs() + ", canExecuteStandardUnixPs=" + PpidChecker.canExecuteStandardUnixPs();
        }
        return "PpidChecker{" + args + '}';
    }

    private abstract class ProcessInfoConsumer {
        private final String charset;
        boolean hasHeader;

        ProcessInfoConsumer(String charset) {
            this.charset = charset;
        }

        @Nonnull
        abstract ProcessInfo consumeLine(String var1, ProcessInfo var2) throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProcessInfo execute(String ... command) {
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.redirectErrorStream(true);
            Process process = null;
            ProcessInfo processInfo = ProcessInfo.INVALID_PROCESS_INFO;
            StringBuilder out = new StringBuilder(64);
            try {
                if (SystemUtils.IS_OS_HP_UX) {
                    processBuilder.environment().put("UNIX95", "1");
                }
                process = processBuilder.start();
                PpidChecker.this.destroyableCommands.add(process);
                Scanner scanner = new Scanner(process.getInputStream(), this.charset);
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    out.append(line).append(StringUtils.NL);
                    processInfo = this.consumeLine(line.trim(), processInfo);
                }
                PpidChecker.checkValid(scanner);
                int exitCode = process.waitFor();
                if (exitCode != 0 || PpidChecker.this.isStopped()) {
                    out.append("<<exit>> <<").append(exitCode).append(">>").append(StringUtils.NL);
                    DumpErrorSingleton.getSingleton().dumpText(out.toString());
                }
                ProcessInfo processInfo2 = PpidChecker.this.isStopped() ? ProcessInfo.ERR_PROCESS_INFO : (exitCode == 0 ? processInfo : ProcessInfo.INVALID_PROCESS_INFO);
                return processInfo2;
            }
            catch (Exception e) {
                if (!(e instanceof InterruptedException) && !(e.getCause() instanceof InterruptedException)) {
                    DumpErrorSingleton.getSingleton().dumpText(out.toString());
                    DumpErrorSingleton.getSingleton().dumpException(e);
                }
                ProcessInfo processInfo3 = ProcessInfo.ERR_PROCESS_INFO;
                return processInfo3;
            }
            finally {
                if (process != null) {
                    PpidChecker.this.destroyableCommands.remove(process);
                    process.destroy();
                    IOUtils.closeQuietly(process.getInputStream());
                    IOUtils.closeQuietly(process.getErrorStream());
                    IOUtils.closeQuietly(process.getOutputStream());
                }
            }
        }
    }
}

