/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.booter;

import java.util.Objects;
import org.apache.maven.shadefire.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.shadefire.surefire.booter.ForkedChannelEncoder;
import org.apache.maven.shadefire.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.shadefire.surefire.report.ConsoleStream;
import org.apache.maven.shadefire.surefire.report.ReportEntry;
import org.apache.maven.shadefire.surefire.report.RunListener;
import org.apache.maven.shadefire.surefire.report.RunMode;
import org.apache.maven.shadefire.surefire.report.TestSetReportEntry;

public class ForkingRunListener
implements RunListener,
ConsoleLogger,
ConsoleOutputReceiver,
ConsoleStream {
    private final ForkedChannelEncoder target;
    private final boolean trim;
    private volatile RunMode runMode = RunMode.NORMAL_RUN;

    public ForkingRunListener(ForkedChannelEncoder target, boolean trim) {
        this.target = target;
        this.trim = trim;
    }

    @Override
    public void testSetStarting(TestSetReportEntry report) {
        this.target.testSetStarting(report, this.trim);
    }

    @Override
    public void testSetCompleted(TestSetReportEntry report) {
        this.target.sendSystemProperties(report.getSystemProperties());
        this.target.testSetCompleted(report, this.trim);
    }

    @Override
    public void testStarting(ReportEntry report) {
        this.target.testStarting(report, this.trim);
    }

    @Override
    public void testSucceeded(ReportEntry report) {
        this.target.testSucceeded(report, this.trim);
    }

    @Override
    public void testAssumptionFailure(ReportEntry report) {
        this.target.testAssumptionFailure(report, this.trim);
    }

    @Override
    public void testError(ReportEntry report) {
        this.target.testError(report, this.trim);
    }

    @Override
    public void testFailed(ReportEntry report) {
        this.target.testFailed(report, this.trim);
    }

    @Override
    public void testSkipped(ReportEntry report) {
        this.target.testSkipped(report, this.trim);
    }

    @Override
    public void testExecutionSkippedByUser() {
        this.target.stopOnNextTest();
    }

    @Override
    public RunMode markAs(RunMode currentRunMode) {
        RunMode runMode = this.runMode;
        this.runMode = Objects.requireNonNull(currentRunMode);
        return runMode;
    }

    @Override
    public void writeTestOutput(String output, boolean newLine, boolean stdout) {
        if (stdout) {
            this.target.stdOut(output, newLine);
        } else {
            this.target.stdErr(output, newLine);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    public void debug(String message) {
        this.target.consoleDebugLog(message);
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public void info(String message) {
        this.target.consoleInfoLog(message);
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public void warning(String message) {
        this.target.consoleWarningLog(message);
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public void error(String message) {
        this.target.consoleErrorLog(message);
    }

    @Override
    public void error(String message, Throwable t) {
        this.target.consoleErrorLog(message, t);
    }

    @Override
    public void error(Throwable t) {
        this.error(null, t);
    }

    @Override
    public void println(String message) {
        this.writeTestOutput(message, true, true);
    }
}

