/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.booter;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.shadefire.plugin.surefire.log.api.ConsoleLoggerUtils;
import org.apache.maven.shadefire.surefire.booter.DumpErrorSingleton;
import org.apache.maven.shadefire.surefire.booter.ForkedProcessEvent;
import org.apache.maven.shadefire.surefire.report.ReportEntry;
import org.apache.maven.shadefire.surefire.report.RunMode;
import org.apache.maven.shadefire.surefire.report.SafeThrowable;
import org.apache.maven.shadefire.surefire.report.StackTraceWriter;
import org.apache.maven.shadefire.surefire.shade.api.org.apache.commons.codec.binary.Base64;

public final class ForkedChannelEncoder {
    private static final Base64 BASE64 = new Base64();
    private static final Charset STREAM_ENCODING = StandardCharsets.US_ASCII;
    private static final Charset STRING_ENCODING = StandardCharsets.UTF_8;
    private final OutputStream out;
    private final RunMode runMode;
    private volatile boolean trouble;

    public ForkedChannelEncoder(OutputStream out) {
        this(out, RunMode.NORMAL_RUN);
    }

    private ForkedChannelEncoder(OutputStream out, RunMode runMode) {
        this.out = Objects.requireNonNull(out);
        this.runMode = Objects.requireNonNull(runMode);
    }

    public ForkedChannelEncoder asRerunMode() {
        return new ForkedChannelEncoder(this.out, RunMode.RERUN_TEST_AFTER_FAILURE);
    }

    public ForkedChannelEncoder asNormalMode() {
        return new ForkedChannelEncoder(this.out, RunMode.NORMAL_RUN);
    }

    public boolean checkError() {
        return this.trouble;
    }

    public void sendSystemProperties(Map<String, String> sysProps) {
        for (Map.Entry<String, String> entry : sysProps.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            StringBuilder event = ForkedChannelEncoder.encode(ForkedProcessEvent.BOOTERCODE_SYSPROPS, this.runMode, key, value);
            this.encodeAndPrintEvent(event);
        }
    }

    public void testSetStarting(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEvent.BOOTERCODE_TESTSET_STARTING, this.runMode, reportEntry, trimStackTraces);
    }

    public void testSetCompleted(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEvent.BOOTERCODE_TESTSET_COMPLETED, this.runMode, reportEntry, trimStackTraces);
    }

    public void testStarting(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEvent.BOOTERCODE_TEST_STARTING, this.runMode, reportEntry, trimStackTraces);
    }

    public void testSucceeded(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEvent.BOOTERCODE_TEST_SUCCEEDED, this.runMode, reportEntry, trimStackTraces);
    }

    public void testFailed(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEvent.BOOTERCODE_TEST_FAILED, this.runMode, reportEntry, trimStackTraces);
    }

    public void testSkipped(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEvent.BOOTERCODE_TEST_SKIPPED, this.runMode, reportEntry, trimStackTraces);
    }

    public void testError(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEvent.BOOTERCODE_TEST_ERROR, this.runMode, reportEntry, trimStackTraces);
    }

    public void testAssumptionFailure(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEvent.BOOTERCODE_TEST_ASSUMPTIONFAILURE, this.runMode, reportEntry, trimStackTraces);
    }

    public void stdOut(String msg, boolean newLine) {
        ForkedProcessEvent event = newLine ? ForkedProcessEvent.BOOTERCODE_STDOUT_NEW_LINE : ForkedProcessEvent.BOOTERCODE_STDOUT;
        this.setOutErr(event.getOpcode(), msg);
    }

    public void stdErr(String msg, boolean newLine) {
        ForkedProcessEvent event = newLine ? ForkedProcessEvent.BOOTERCODE_STDERR_NEW_LINE : ForkedProcessEvent.BOOTERCODE_STDERR;
        this.setOutErr(event.getOpcode(), msg);
    }

    private void setOutErr(String eventType, String message) {
        String base64Message = ForkedChannelEncoder.toBase64(message);
        StringBuilder event = ForkedChannelEncoder.encodeMessage(eventType, this.runMode.geRunName(), base64Message);
        this.encodeAndPrintEvent(event);
    }

    public void consoleInfoLog(String msg) {
        StringBuilder event = this.print(ForkedProcessEvent.BOOTERCODE_CONSOLE_INFO.getOpcode(), msg);
        this.encodeAndPrintEvent(event);
    }

    public void consoleErrorLog(String msg) {
        StringBuilder event = this.print(ForkedProcessEvent.BOOTERCODE_CONSOLE_ERROR.getOpcode(), msg);
        this.encodeAndPrintEvent(event);
    }

    public void consoleErrorLog(Throwable t) {
        this.consoleErrorLog(t.getLocalizedMessage(), t);
    }

    public void consoleErrorLog(String msg, Throwable t) {
        StringBuilder encoded = ForkedChannelEncoder.encodeHeader(ForkedProcessEvent.BOOTERCODE_CONSOLE_ERROR.getOpcode(), null);
        ForkedChannelEncoder.encode(encoded, msg, null, ConsoleLoggerUtils.toString(t));
        this.encodeAndPrintEvent(encoded);
    }

    public void consoleErrorLog(StackTraceWriter stackTraceWriter, boolean trimStackTraces) {
        this.error(stackTraceWriter, trimStackTraces, ForkedProcessEvent.BOOTERCODE_CONSOLE_ERROR);
    }

    public void consoleDebugLog(String msg) {
        StringBuilder event = this.print(ForkedProcessEvent.BOOTERCODE_CONSOLE_DEBUG.getOpcode(), msg);
        this.encodeAndPrintEvent(event);
    }

    public void consoleWarningLog(String msg) {
        StringBuilder event = this.print(ForkedProcessEvent.BOOTERCODE_CONSOLE_WARNING.getOpcode(), msg);
        this.encodeAndPrintEvent(event);
    }

    public void bye() {
        this.encodeOpcode(ForkedProcessEvent.BOOTERCODE_BYE);
    }

    public void stopOnNextTest() {
        this.encodeOpcode(ForkedProcessEvent.BOOTERCODE_STOP_ON_NEXT_TEST);
    }

    public void acquireNextTest() {
        this.encodeOpcode(ForkedProcessEvent.BOOTERCODE_NEXT_TEST);
    }

    public void sendExitEvent(StackTraceWriter stackTraceWriter, boolean trimStackTraces) {
        this.error(stackTraceWriter, trimStackTraces, ForkedProcessEvent.BOOTERCODE_JVM_EXIT_ERROR);
    }

    private void error(StackTraceWriter stackTraceWriter, boolean trimStackTraces, ForkedProcessEvent event) {
        StringBuilder encoded = ForkedChannelEncoder.encodeHeader(event.getOpcode(), null);
        ForkedChannelEncoder.encode(encoded, stackTraceWriter, trimStackTraces);
        this.encodeAndPrintEvent(encoded);
    }

    private void encode(ForkedProcessEvent operation, RunMode runMode, ReportEntry reportEntry, boolean trimStackTraces) {
        StringBuilder event = ForkedChannelEncoder.encode(operation.getOpcode(), runMode.geRunName(), reportEntry, trimStackTraces);
        this.encodeAndPrintEvent(event);
    }

    private void encodeOpcode(ForkedProcessEvent operation) {
        StringBuilder event = ForkedChannelEncoder.encodeOpcode(operation.getOpcode(), null);
        this.encodeAndPrintEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeAndPrintEvent(StringBuilder command) {
        byte[] array = command.append('\n').toString().getBytes(STREAM_ENCODING);
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            try {
                this.out.write(array);
                this.out.flush();
            }
            catch (IOException e) {
                DumpErrorSingleton.getSingleton().dumpException(e);
                this.trouble = true;
            }
        }
    }

    static StringBuilder encode(ForkedProcessEvent operation, RunMode runMode, String ... args) {
        StringBuilder encodedTo = ForkedChannelEncoder.encodeHeader(operation.getOpcode(), runMode.geRunName()).append(':');
        int i = 0;
        while (i < args.length) {
            String arg = args[i++];
            encodedTo.append(ForkedChannelEncoder.toBase64(arg));
            if (i == args.length) continue;
            encodedTo.append(':');
        }
        return encodedTo;
    }

    static void encode(StringBuilder encoded, StackTraceWriter stw, boolean trimStackTraces) {
        SafeThrowable throwable = stw == null ? null : stw.getThrowable();
        String message = throwable == null ? null : throwable.getLocalizedMessage();
        String smartStackTrace = stw == null ? null : stw.smartTrimmedStackTrace();
        String stackTrace = stw == null ? null : ForkedChannelEncoder.toStackTrace(stw, trimStackTraces);
        ForkedChannelEncoder.encode(encoded, message, smartStackTrace, stackTrace);
    }

    private static void encode(StringBuilder encoded, String message, String smartStackTrace, String stackTrace) {
        encoded.append(':').append(ForkedChannelEncoder.toBase64(message)).append(':').append(ForkedChannelEncoder.toBase64(smartStackTrace)).append(':').append(ForkedChannelEncoder.toBase64(stackTrace));
    }

    static StringBuilder encode(String operation, String runMode, ReportEntry reportEntry, boolean trimStackTraces) {
        StringBuilder encodedTo = ForkedChannelEncoder.encodeHeader(operation, runMode).append(':').append(ForkedChannelEncoder.toBase64(reportEntry.getSourceName())).append(':').append(ForkedChannelEncoder.toBase64(reportEntry.getSourceText())).append(':').append(ForkedChannelEncoder.toBase64(reportEntry.getName())).append(':').append(ForkedChannelEncoder.toBase64(reportEntry.getNameText())).append(':').append(ForkedChannelEncoder.toBase64(reportEntry.getGroup())).append(':').append(ForkedChannelEncoder.toBase64(reportEntry.getMessage())).append(':').append(reportEntry.getElapsed() == null ? "-" : reportEntry.getElapsed().toString());
        ForkedChannelEncoder.encode(encodedTo, reportEntry.getStackTraceWriter(), trimStackTraces);
        return encodedTo;
    }

    StringBuilder print(String operation, String ... msgs) {
        String[] encodedMsgs = new String[msgs.length];
        for (int i = 0; i < encodedMsgs.length; ++i) {
            String msg = msgs[i];
            encodedMsgs[i] = ForkedChannelEncoder.toBase64(msg);
        }
        return ForkedChannelEncoder.encodeMessage(operation, null, encodedMsgs);
    }

    static StringBuilder encodeMessage(String operation, String runMode, String ... encodedMsgs) {
        StringBuilder builder = ForkedChannelEncoder.encodeHeader(operation, runMode);
        for (String encodedMsg : encodedMsgs) {
            builder.append(':').append(encodedMsg);
        }
        return builder;
    }

    static StringBuilder encodeHeader(String operation, String runMode) {
        return ForkedChannelEncoder.encodeOpcode(operation, runMode).append(':').append(STRING_ENCODING.name());
    }

    static StringBuilder encodeOpcode(String operation, String runMode) {
        StringBuilder s = new StringBuilder(128).append(":maven:surefire:std:out:").append(operation);
        return runMode == null ? s : s.append(':').append(runMode);
    }

    private static String toStackTrace(StackTraceWriter stw, boolean trimStackTraces) {
        return trimStackTraces ? stw.writeTrimmedTraceToString() : stw.writeTraceToString();
    }

    static String toBase64(String msg) {
        return msg == null ? "-" : new String(BASE64.encode(msg.getBytes(STRING_ENCODING)), STREAM_ENCODING);
    }
}

