/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.util.internal;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;

public final class StringUtils {
    public static final String NL = System.lineSeparator();
    private static final byte[] HEX_CHARS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();

    private StringUtils() {
        throw new IllegalStateException("no instantiable constructor");
    }

    public static String[] split(String text, String separator) {
        StringTokenizer tok = separator == null ? new StringTokenizer(text) : new StringTokenizer(text, separator);
        String[] list = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            list[i] = tok.nextToken();
            ++i;
        }
        return list;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static void escapeToPrintable(StringBuilder target, CharSequence str) {
        if (target == null) {
            throw new IllegalArgumentException("The target buffer must not be null");
        }
        if (str == null) {
            return;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c < ' ' || c > '~' || c == '\\' || c == ',') {
                target.append('\\');
                target.append((char)HEX_CHARS[(0xF000 & c) >> 12]);
                target.append((char)HEX_CHARS[(0xF00 & c) >> 8]);
                target.append((char)HEX_CHARS[(0xF0 & c) >> 4]);
                target.append((char)HEX_CHARS[0xF & c]);
                continue;
            }
            target.append(c);
        }
    }

    public static void unescapeString(StringBuilder target, CharSequence str) {
        if (target == null) {
            throw new IllegalArgumentException("The target buffer must not be null");
        }
        if (str == null) {
            return;
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\\') {
                target.append((char)(StringUtils.digit(str.charAt(++i)) << 12 | StringUtils.digit(str.charAt(++i)) << 8 | StringUtils.digit(str.charAt(++i)) << 4 | StringUtils.digit(str.charAt(++i))));
                continue;
            }
            target.append(ch);
        }
    }

    private static int digit(char ch) {
        if (ch >= 'a') {
            return 10 + ch - 97;
        }
        if (ch >= 'A') {
            return 10 + ch - 65;
        }
        return ch - 48;
    }

    public static EncodedArray escapeBytesToPrintable(byte[] header, byte[] input, int off, int len) {
        if (input.length == 0) {
            return EncodedArray.EMPTY;
        }
        if (off < 0 || len < 0 || off >= input.length || len > input.length || off + len > input.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off >= input.length || len > input.length || off + len > input.length");
        }
        byte[] encodeBytes = new byte[header.length + 3 * len + 1];
        System.arraycopy(header, 0, encodeBytes, 0, header.length);
        int outputPos = header.length;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            byte b = input[i];
            if (b < 32 || b > 126 || b == 92 || b == 44) {
                int upper = (0xF0 & b) >> 4;
                int lower = 0xF & b;
                encodeBytes[outputPos++] = 92;
                encodeBytes[outputPos++] = HEX_CHARS[upper];
                encodeBytes[outputPos++] = HEX_CHARS[lower];
                continue;
            }
            encodeBytes[outputPos++] = b;
        }
        encodeBytes[outputPos++] = 10;
        return new EncodedArray(encodeBytes, outputPos);
    }

    public static ByteBuffer unescapeBytes(String str, String charsetName) {
        int outPos = 0;
        if (str == null) {
            return ByteBuffer.wrap(new byte[0]);
        }
        byte[] out = new byte[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\\') {
                int upper = StringUtils.digit(str.charAt(++i));
                int lower = StringUtils.digit(str.charAt(++i));
                out[outPos++] = (byte)(upper << 4 | lower);
                continue;
            }
            out[outPos++] = (byte)ch;
        }
        Charset sourceCharset = Charset.forName(charsetName);
        if (!DEFAULT_CHARSET.equals(sourceCharset)) {
            try {
                CharBuffer decodedFromSourceCharset = sourceCharset.newDecoder().decode(ByteBuffer.wrap(out, 0, outPos));
                return DEFAULT_CHARSET.encode(decodedFromSourceCharset);
            }
            catch (CharacterCodingException characterCodingException) {
                // empty catch block
            }
        }
        return ByteBuffer.wrap(out, 0, outPos);
    }

    public static byte[] encodeStringForForkCommunication(String string) {
        return string.getBytes(StandardCharsets.ISO_8859_1);
    }

    public static boolean startsWith(StringBuffer buffer, String pattern) {
        if (buffer.length() < pattern.length()) {
            return false;
        }
        int len = pattern.length();
        for (int i = 0; i < len; ++i) {
            if (buffer.charAt(i) == pattern.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static final class EncodedArray {
        private static final EncodedArray EMPTY = new EncodedArray(new byte[0], 0);
        private final byte[] array;
        private final int size;

        private EncodedArray(byte[] array, int size) {
            this.array = array;
            this.size = size;
        }

        public byte[] getArray() {
            return this.array;
        }

        public int getSize() {
            return this.size;
        }
    }
}

