/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.junit;

import java.util.Map;
import org.apache.maven.shadefire.surefire.common.junit3.JUnit3Reflector;
import org.apache.maven.shadefire.surefire.common.junit3.JUnit3TestChecker;
import org.apache.maven.shadefire.surefire.junit.JUnitTestSet;
import org.apache.maven.shadefire.surefire.junit.PojoAndJUnit3Checker;
import org.apache.maven.shadefire.surefire.junit.PojoTestSet;
import org.apache.maven.shadefire.surefire.junit.SurefireTestSet;
import org.apache.maven.shadefire.surefire.providerapi.AbstractProvider;
import org.apache.maven.shadefire.surefire.providerapi.ProviderParameters;
import org.apache.maven.shadefire.surefire.report.ConsoleOutputCapture;
import org.apache.maven.shadefire.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.shadefire.surefire.report.ReporterFactory;
import org.apache.maven.shadefire.surefire.report.RunListener;
import org.apache.maven.shadefire.surefire.report.SimpleReportEntry;
import org.apache.maven.shadefire.surefire.suite.RunResult;
import org.apache.maven.shadefire.surefire.testset.TestSetFailedException;
import org.apache.maven.shadefire.surefire.util.ReflectionUtils;
import org.apache.maven.shadefire.surefire.util.RunOrderCalculator;
import org.apache.maven.shadefire.surefire.util.ScanResult;
import org.apache.maven.shadefire.surefire.util.TestsToRun;
import org.apache.maven.shadefire.surefire.util.internal.ObjectUtils;

public class JUnit3Provider
extends AbstractProvider {
    private final ClassLoader testClassLoader;
    private final PojoAndJUnit3Checker testChecker;
    private final JUnit3TestChecker jUnit3TestChecker;
    private final JUnit3Reflector reflector;
    private final ProviderParameters providerParameters;
    private final RunOrderCalculator runOrderCalculator;
    private final ScanResult scanResult;
    private TestsToRun testsToRun;

    public JUnit3Provider(ProviderParameters booterParameters) {
        this.providerParameters = booterParameters;
        this.testClassLoader = booterParameters.getTestClassLoader();
        this.scanResult = booterParameters.getScanResult();
        this.runOrderCalculator = booterParameters.getRunOrderCalculator();
        this.reflector = new JUnit3Reflector(this.testClassLoader);
        this.jUnit3TestChecker = new JUnit3TestChecker(this.testClassLoader);
        this.testChecker = new PojoAndJUnit3Checker(this.jUnit3TestChecker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunResult invoke(Object forkTestSet) throws TestSetFailedException {
        RunResult runResult;
        if (this.testsToRun == null) {
            this.testsToRun = forkTestSet instanceof TestsToRun ? (TestsToRun)forkTestSet : (forkTestSet instanceof Class ? TestsToRun.fromClass((Class)forkTestSet) : this.scanClassPath());
        }
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        try {
            RunListener reporter = reporterFactory.createReporter();
            ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)((Object)reporter));
            Map<String, String> systemProperties = ObjectUtils.systemProps();
            String smClassName = systemProperties.get("surefire.security.manager");
            if (smClassName != null) {
                SecurityManager securityManager = ReflectionUtils.instantiate(this.getClass().getClassLoader(), smClassName, SecurityManager.class);
                System.setSecurityManager(securityManager);
            }
            for (Class<?> clazz : this.testsToRun) {
                SurefireTestSet surefireTestSet = this.createTestSet(clazz);
                this.executeTestSet(surefireTestSet, reporter, this.testClassLoader, systemProperties);
            }
        }
        finally {
            runResult = reporterFactory.close();
        }
        return runResult;
    }

    private SurefireTestSet createTestSet(Class<?> clazz) throws TestSetFailedException {
        return this.reflector.isJUnit3Available() && this.jUnit3TestChecker.accept(clazz) ? new JUnitTestSet(clazz, this.reflector) : new PojoTestSet(clazz);
    }

    private void executeTestSet(SurefireTestSet testSet, RunListener reporter, ClassLoader classLoader, Map<String, String> systemProperties) throws TestSetFailedException {
        SimpleReportEntry report = new SimpleReportEntry(this.getClass().getName(), testSet.getName(), systemProperties);
        reporter.testSetStarting(report);
        testSet.execute(reporter, classLoader);
        reporter.testSetCompleted(report);
    }

    private TestsToRun scanClassPath() {
        TestsToRun testsToRun = this.scanResult.applyFilter(this.testChecker, this.testClassLoader);
        return this.runOrderCalculator.orderTestClasses(testsToRun);
    }

    @Override
    public Iterable<Class<?>> getSuites() {
        this.testsToRun = this.scanClassPath();
        return this.testsToRun;
    }
}

