/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.maven.shadefire.surefire.util.SurefireReflectionException;

public final class ReflectionUtils {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    private ReflectionUtils() {
        throw new IllegalStateException("no instantiable constructor");
    }

    public static Method getMethod(Object instance, String methodName, Class<?> ... parameters) {
        return ReflectionUtils.getMethod(instance.getClass(), methodName, parameters);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            return clazz.getMethod(methodName, parameters);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("When finding method " + methodName, e);
        }
    }

    public static Method tryGetMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            return clazz.getMethod(methodName, parameters);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Object invokeGetter(Object instance, String methodName) {
        return ReflectionUtils.invokeGetter(instance.getClass(), instance, methodName);
    }

    public static Object invokeGetter(Class<?> instanceType, Object instance, String methodName) {
        Method method = ReflectionUtils.getMethod(instanceType, methodName, new Class[0]);
        return ReflectionUtils.invokeMethodWithArray(instance, method, new Object[0]);
    }

    public static Constructor getConstructor(Class<?> clazz, Class<?> ... arguments) {
        try {
            return clazz.getConstructor(arguments);
        }
        catch (NoSuchMethodException e) {
            throw new SurefireReflectionException(e);
        }
    }

    public static Object newInstance(Constructor constructor, Object ... params) {
        try {
            return constructor.newInstance(params);
        }
        catch (ReflectiveOperationException e) {
            throw new SurefireReflectionException(e);
        }
    }

    public static <T> T instantiate(ClassLoader classLoader, String classname, Class<T> returnType) {
        try {
            Class<?> clazz = ReflectionUtils.loadClass(classLoader, classname);
            return returnType.cast(clazz.newInstance());
        }
        catch (ReflectiveOperationException e) {
            throw new SurefireReflectionException(e);
        }
    }

    public static Object instantiateOneArg(ClassLoader classLoader, String className, Class<?> param1Class, Object param1) {
        try {
            Class<?> aClass = ReflectionUtils.loadClass(classLoader, className);
            Constructor constructor = ReflectionUtils.getConstructor(aClass, param1Class);
            return constructor.newInstance(param1);
        }
        catch (InvocationTargetException e) {
            throw new SurefireReflectionException(e.getTargetException());
        }
        catch (ReflectiveOperationException e) {
            throw new SurefireReflectionException(e);
        }
    }

    public static Object instantiateTwoArgs(ClassLoader classLoader, String className, Class<?> param1Class, Object param1, Class param2Class, Object param2) {
        try {
            Class<?> aClass = ReflectionUtils.loadClass(classLoader, className);
            Constructor constructor = ReflectionUtils.getConstructor(aClass, param1Class, param2Class);
            return constructor.newInstance(param1, param2);
        }
        catch (InvocationTargetException e) {
            throw new SurefireReflectionException(e.getTargetException());
        }
        catch (ReflectiveOperationException e) {
            throw new SurefireReflectionException(e);
        }
    }

    public static void invokeSetter(Object o, String name, Class<?> value1clazz, Object value) {
        Method setter = ReflectionUtils.getMethod(o, name, value1clazz);
        ReflectionUtils.invokeSetter(o, setter, value);
    }

    public static Object invokeSetter(Object target, Method method, Object value) {
        return ReflectionUtils.invokeMethodWithArray(target, method, value);
    }

    public static Object invokeMethodWithArray(Object target, Method method, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw new SurefireReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new SurefireReflectionException(e.getTargetException());
        }
    }

    public static Object invokeMethodWithArray2(Object target, Method method, Object ... args) throws InvocationTargetException {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw new SurefireReflectionException(e);
        }
    }

    public static Object instantiateObject(String className, Class[] types, Object[] params, ClassLoader classLoader) {
        Class<?> clazz = ReflectionUtils.loadClass(classLoader, className);
        Constructor constructor = ReflectionUtils.getConstructor(clazz, types);
        return ReflectionUtils.newInstance(constructor, params);
    }

    public static Class<?> tryLoadClass(ClassLoader classLoader, String className) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            return null;
        }
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new SurefireReflectionException(e);
        }
    }

    public static Object invokeStaticMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Object[] parameters) {
        if (parameterTypes.length != parameters.length) {
            throw new IllegalArgumentException("arguments length do not match");
        }
        Method method = ReflectionUtils.getMethod(clazz, methodName, parameterTypes);
        return ReflectionUtils.invokeMethodWithArray(null, method, parameters);
    }

    public static Object invokeMethodChain(Class<?>[] classesChain, String[] noArgMethodNames, Object fallback) {
        if (classesChain.length != noArgMethodNames.length) {
            throw new IllegalArgumentException("arrays must have the same length");
        }
        Object obj = null;
        try {
            int len = noArgMethodNames.length;
            for (int i = 0; i < len; ++i) {
                if (i == 0) {
                    obj = ReflectionUtils.invokeStaticMethod(classesChain[i], noArgMethodNames[i], EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
                    continue;
                }
                Method method = ReflectionUtils.getMethod(classesChain[i], noArgMethodNames[i], new Class[0]);
                obj = ReflectionUtils.invokeMethodWithArray(obj, method, new Object[0]);
            }
            return obj;
        }
        catch (RuntimeException e) {
            return fallback;
        }
    }
}

