/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.junit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.shadefire.surefire.junit.SurefireTestSet;
import org.apache.maven.shadefire.surefire.report.LegacyPojoStackTraceWriter;
import org.apache.maven.shadefire.surefire.report.RunListener;
import org.apache.maven.shadefire.surefire.report.SimpleReportEntry;
import org.apache.maven.shadefire.surefire.testset.TestSetFailedException;

public class PojoTestSet
implements SurefireTestSet {
    private static final String TEST_METHOD_PREFIX = "test";
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Object testObject;
    private final Class<?> testClass;
    private List<Method> testMethods;
    private Method setUpMethod;
    private Method tearDownMethod;

    public PojoTestSet(Class<?> testClass) throws TestSetFailedException {
        if (testClass == null) {
            throw new IllegalArgumentException("testClass is null");
        }
        this.testClass = testClass;
        try {
            this.testObject = testClass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new TestSetFailedException("Unable to instantiate POJO '" + testClass + "'", e);
        }
    }

    @Override
    public void execute(RunListener reportManager, ClassLoader loader) {
        if (reportManager == null) {
            throw new NullPointerException("reportManager is null");
        }
        this.executeTestMethods(reportManager);
    }

    private void executeTestMethods(RunListener reportManager) {
        if (reportManager == null) {
            throw new NullPointerException("reportManager is null");
        }
        if (this.testMethods == null) {
            this.discoverTestMethods();
        }
        boolean abort = false;
        for (int i = 0; i < this.testMethods.size() && !abort; ++i) {
            abort = this.executeTestMethod(this.testMethods.get(i), EMPTY_OBJECT_ARRAY, reportManager);
        }
    }

    private boolean executeTestMethod(Method method, Object[] args, RunListener reportManager) {
        LegacyPojoStackTraceWriter stackTraceWriter;
        if (method == null || args == null || reportManager == null) {
            throw new NullPointerException();
        }
        String testClassName = this.getTestClass().getName();
        String methodName = method.getName();
        String userFriendlyMethodName = methodName + '(' + (args.length == 0 ? "" : "Reporter") + ')';
        String testName = this.getTestName(userFriendlyMethodName);
        reportManager.testStarting(new SimpleReportEntry(testClassName, testName));
        try {
            this.setUpFixture();
        }
        catch (Throwable e) {
            LegacyPojoStackTraceWriter stackTraceWriter2 = new LegacyPojoStackTraceWriter(testClassName, methodName, e);
            reportManager.testFailed(SimpleReportEntry.withException(testClassName, testName, stackTraceWriter2));
            return true;
        }
        try {
            method.invoke(this.testObject, args);
            reportManager.testSucceeded(new SimpleReportEntry(testClassName, testName));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            LegacyPojoStackTraceWriter stackTraceWriter3 = new LegacyPojoStackTraceWriter(testClassName, methodName, t);
            reportManager.testFailed(SimpleReportEntry.withException(testClassName, testName, stackTraceWriter3));
        }
        catch (Throwable t) {
            stackTraceWriter = new LegacyPojoStackTraceWriter(testClassName, methodName, t);
            reportManager.testFailed(SimpleReportEntry.withException(testClassName, testName, stackTraceWriter));
        }
        try {
            this.tearDownFixture();
        }
        catch (Throwable t) {
            stackTraceWriter = new LegacyPojoStackTraceWriter(testClassName, methodName, t);
            reportManager.testFailed(SimpleReportEntry.withException(testClassName, testName, stackTraceWriter));
            return true;
        }
        return false;
    }

    private String getTestName(String testMethodName) {
        if (testMethodName == null) {
            throw new NullPointerException("testMethodName is null");
        }
        return this.getTestClass().getName() + "." + testMethodName;
    }

    private void setUpFixture() throws Throwable {
        if (this.setUpMethod != null) {
            this.setUpMethod.invoke(this.testObject, new Object[0]);
        }
    }

    private void tearDownFixture() throws Throwable {
        if (this.tearDownMethod != null) {
            this.tearDownMethod.invoke(this.testObject, new Object[0]);
        }
    }

    private void discoverTestMethods() {
        if (this.testMethods == null) {
            Method[] methods;
            this.testMethods = new ArrayList<Method>();
            for (Method m : methods = this.getTestClass().getMethods()) {
                if (PojoTestSet.isValidTestMethod(m)) {
                    String firstFour;
                    String simpleName = m.getName();
                    if (simpleName.length() <= 4 || !(firstFour = simpleName.substring(0, 4)).equals(TEST_METHOD_PREFIX)) continue;
                    this.testMethods.add(m);
                    continue;
                }
                if (m.getName().equals("setUp") && m.getParameterTypes().length == 0) {
                    this.setUpMethod = m;
                    continue;
                }
                if (!m.getName().equals("tearDown") || m.getParameterTypes().length != 0) continue;
                this.tearDownMethod = m;
            }
        }
    }

    private static boolean isValidTestMethod(Method m) {
        boolean isInstanceMethod = !Modifier.isStatic(m.getModifiers());
        boolean returnsVoid = m.getReturnType().equals(Void.TYPE);
        boolean hasNoParams = m.getParameterTypes().length == 0;
        return isInstanceMethod && returnsVoid && hasNoParams;
    }

    @Override
    public String getName() {
        return this.getTestClass().getName();
    }

    private Class<?> getTestClass() {
        return this.testClass;
    }
}

