/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.booter;

final class ProcessInfo {
    static final ProcessInfo INVALID_PROCESS_INFO = new ProcessInfo(null, null);
    static final ProcessInfo ERR_PROCESS_INFO = new ProcessInfo(null, null);
    private final Long pid;
    private final Comparable time;

    static ProcessInfo unixProcessInfo(long pid, long etime) {
        return new ProcessInfo(pid, Long.valueOf(etime));
    }

    static ProcessInfo windowsProcessInfo(long pid, long startTimestamp) {
        return new ProcessInfo(pid, Long.valueOf(startTimestamp));
    }

    private ProcessInfo(Long pid, Comparable time) {
        this.pid = pid;
        this.time = time;
    }

    boolean canUse() {
        return !this.isInvalid() && !this.isError();
    }

    boolean isInvalid() {
        return this == INVALID_PROCESS_INFO;
    }

    boolean isError() {
        return this == ERR_PROCESS_INFO;
    }

    long getPID() {
        this.checkValid();
        return this.pid;
    }

    Comparable getTime() {
        this.checkValid();
        return this.time;
    }

    boolean isTimeEqualTo(ProcessInfo that) {
        this.checkValid();
        that.checkValid();
        return this.time.compareTo(that.time) == 0;
    }

    boolean isTimeBefore(ProcessInfo that) {
        this.checkValid();
        that.checkValid();
        return this.time.compareTo(that.time) < 0;
    }

    private void checkValid() {
        if (!this.canUse()) {
            throw new IllegalStateException("invalid process info");
        }
    }
}

