/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.booter;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Iterator;
import org.apache.maven.shadefire.surefire.booter.CommandReader;
import org.apache.maven.shadefire.surefire.util.CloseableIterator;
import org.apache.maven.shadefire.surefire.util.ReflectionUtils;
import org.apache.maven.shadefire.surefire.util.TestsToRun;

final class LazyTestsToRun
extends TestsToRun {
    private final PrintStream originalOutStream;

    LazyTestsToRun(PrintStream originalOutStream) {
        super(Collections.emptySet());
        this.originalOutStream = originalOutStream;
    }

    @Override
    public Iterator<Class<?>> iterated() {
        return this.newWeakIterator();
    }

    @Override
    public Iterator<Class<?>> iterator() {
        return new BlockingIterator();
    }

    @Override
    public String toString() {
        return "LazyTestsToRun";
    }

    @Override
    public boolean allowEagerReading() {
        return false;
    }

    private static Class<?> findClass(String clazz) {
        return ReflectionUtils.loadClass(Thread.currentThread().getContextClassLoader(), clazz);
    }

    private Iterator<Class<?>> newWeakIterator() {
        final Iterator<String> it = CommandReader.getReader().iterated();
        return new CloseableIterator<Class<?>>(){

            @Override
            protected boolean isClosed() {
                return LazyTestsToRun.this.isFinished();
            }

            @Override
            protected boolean doHasNext() {
                return it.hasNext();
            }

            @Override
            protected Class<?> doNext() {
                return LazyTestsToRun.findClass((String)it.next());
            }

            @Override
            protected void doRemove() {
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("unsupported remove");
            }
        };
    }

    private final class BlockingIterator
    implements Iterator<Class<?>> {
        private final Iterator<String> it;

        private BlockingIterator() {
            this.it = CommandReader.getReader().getIterableClasses(LazyTestsToRun.this.originalOutStream).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Class<?> next() {
            return LazyTestsToRun.findClass(this.it.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

