/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.booter;

import javax.annotation.Nonnull;
import org.apache.maven.shadefire.surefire.booter.Classpath;
import org.apache.maven.shadefire.surefire.booter.ClasspathConfiguration;
import org.apache.maven.shadefire.surefire.booter.ModularClasspathConfiguration;
import org.apache.maven.shadefire.surefire.booter.SurefireExecutionException;

public abstract class AbstractPathConfiguration {
    public static final String CHILD_DELEGATION = "childDelegation";
    public static final String ENABLE_ASSERTIONS = "enableAssertions";
    public static final String CLASSPATH = "classPathUrl.";
    public static final String SUREFIRE_CLASSPATH = "surefireClassPathUrl.";
    private final Classpath surefireClasspathUrls;
    private final boolean enableAssertions;
    private final boolean childDelegation;

    protected AbstractPathConfiguration(@Nonnull Classpath surefireClasspathUrls, boolean enableAssertions, boolean childDelegation) {
        if (this.isClassPathConfig() == this.isModularPathConfig()) {
            throw new IllegalStateException("modular path and class path should be exclusive");
        }
        this.surefireClasspathUrls = surefireClasspathUrls;
        this.enableAssertions = enableAssertions;
        this.childDelegation = childDelegation;
    }

    public abstract Classpath getTestClasspath();

    public abstract boolean isModularPathConfig();

    public abstract boolean isClassPathConfig();

    protected Classpath getInprocClasspath() {
        return Classpath.emptyClasspath();
    }

    public <T extends AbstractPathConfiguration> T toRealPath(Class<T> type) {
        if (this.isClassPathConfig() && type == ClasspathConfiguration.class || this.isModularPathConfig() && type == ModularClasspathConfiguration.class) {
            return (T)((AbstractPathConfiguration)type.cast(this));
        }
        throw new IllegalStateException("no target matched " + type);
    }

    public ClassLoader createMergedClassLoader() throws SurefireExecutionException {
        return Classpath.join(this.getInprocClasspath(), this.getTestClasspath()).createClassLoader(this.isChildDelegation(), this.isEnableAssertions(), "test");
    }

    public Classpath getProviderClasspath() {
        return this.surefireClasspathUrls;
    }

    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    @Deprecated
    public boolean isChildDelegation() {
        return this.childDelegation;
    }
}

