/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shadefire.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.shadefire.testset.TestSetFailedException;

public class TestsToRun {
    private final List locatedClasses;

    public TestsToRun(List locatedClasses) {
        this.locatedClasses = Collections.unmodifiableList(locatedClasses);
        HashSet<Class> testSets = new HashSet<Class>();
        Iterator iterator = locatedClasses.iterator();
        while (iterator.hasNext()) {
            Class testClass = (Class)iterator.next();
            if (testSets.contains(testClass)) {
                throw new RuntimeException("Duplicate test set '" + testClass.getName() + "'");
            }
            testSets.add(testClass);
        }
    }

    public static TestsToRun fromClass(Class clazz) throws TestSetFailedException {
        return new TestsToRun(Arrays.asList(clazz));
    }

    public int size() {
        return this.locatedClasses.size();
    }

    public Class[] getLocatedClasses() {
        return this.locatedClasses.toArray(new Class[this.locatedClasses.size()]);
    }

    public Iterator iterator() {
        return this.locatedClasses.iterator();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TestsToRun: [");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Class clazz = (Class)it.next();
            sb.append(" ").append(clazz.getName());
        }
        sb.append(']');
        return sb.toString();
    }
}

