/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shadefire.booter;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.maven.surefire.shadefire.booter.TypeEncodedValue;
import org.apache.maven.surefire.shadefire.report.ReporterConfiguration;
import org.apache.maven.surefire.shadefire.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.shadefire.testset.RunOrderParameters;
import org.apache.maven.surefire.shadefire.testset.TestArtifactInfo;
import org.apache.maven.surefire.shadefire.testset.TestRequest;

public class ProviderConfiguration {
    public static final int TESTS_SUCCEEDED_EXIT_CODE = 0;
    public static final int TESTS_FAILED_EXIT_CODE = 255;
    public static final int NO_TESTS_EXIT_CODE = 254;
    private final DirectoryScannerParameters dirScannerParams;
    private final ReporterConfiguration reporterConfiguration;
    private final TestArtifactInfo testArtifact;
    private final TestRequest testSuiteDefinition;
    private final RunOrderParameters runOrderParameters;
    private final Properties providerProperties;
    private final boolean failIfNoTests;
    private final TypeEncodedValue forkTestSet;

    public ProviderConfiguration(DirectoryScannerParameters directoryScannerParameters, RunOrderParameters runOrderParameters, boolean failIfNoTests, ReporterConfiguration reporterConfiguration, TestArtifactInfo testArtifact, TestRequest testSuiteDefinition, Properties providerProperties, TypeEncodedValue typeEncodedTestSet) {
        this.runOrderParameters = runOrderParameters;
        this.providerProperties = providerProperties;
        this.reporterConfiguration = reporterConfiguration;
        this.testArtifact = testArtifact;
        this.testSuiteDefinition = testSuiteDefinition;
        this.dirScannerParams = directoryScannerParameters;
        this.failIfNoTests = failIfNoTests;
        this.forkTestSet = typeEncodedTestSet;
    }

    public ReporterConfiguration getReporterConfiguration() {
        return this.reporterConfiguration;
    }

    public Boolean isFailIfNoTests() {
        return this.failIfNoTests ? Boolean.TRUE : Boolean.FALSE;
    }

    public File getBaseDir() {
        return this.dirScannerParams.getTestClassesDirectory();
    }

    public DirectoryScannerParameters getDirScannerParams() {
        return this.dirScannerParams;
    }

    public List getIncludes() {
        return this.dirScannerParams.getIncludes();
    }

    public List getExcludes() {
        return this.dirScannerParams.getExcludes();
    }

    public TestArtifactInfo getTestArtifact() {
        return this.testArtifact;
    }

    public TestRequest getTestSuiteDefinition() {
        return this.testSuiteDefinition;
    }

    public Properties getProviderProperties() {
        return this.providerProperties;
    }

    public TypeEncodedValue getTestForFork() {
        return this.forkTestSet;
    }

    public RunOrderParameters getRunOrderParameters() {
        return this.runOrderParameters;
    }
}

