/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shadefire.suite;

import java.util.StringTokenizer;

public class RunResult {
    private final int completedCount;
    private final int errors;
    private final int failures;
    private final int skipped;
    private final boolean failure;
    private final boolean timeout;
    public static final int SUCCESS = 0;
    private static final int FAILURE = 255;
    private static final int NO_TESTS = 254;
    public static final RunResult Timeout = new RunResult(0, 0, 0, 0, false, true);

    public RunResult(int completedCount, int errors, int failures, int skipped) {
        this(completedCount, errors, failures, skipped, false, false);
    }

    public RunResult(int completedCount, int errors, int failures, int skipped, boolean failure, boolean timeout) {
        this.completedCount = completedCount;
        this.errors = errors;
        this.failures = failures;
        this.skipped = skipped;
        this.failure = failure;
        this.timeout = timeout;
    }

    public int getCompletedCount() {
        return this.completedCount;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getFailures() {
        return this.failures;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public int getForkedProcessCode() {
        return this.completedCount == 0 ? 254 : (this.isErrorFree() ? 0 : 255);
    }

    public boolean isErrorFree() {
        return this.getFailures() == 0 && this.getErrors() == 0;
    }

    public String getAsString() {
        return this.getCompletedCount() + "," + this.getErrors() + "," + this.getFailures() + "," + this.getSkipped() + "," + this.isFailure() + "," + this.isTimeout();
    }

    public static RunResult fromString(String string) {
        StringTokenizer strTok = new StringTokenizer(string, ",");
        int completed = Integer.parseInt(strTok.nextToken());
        int errors = Integer.parseInt(strTok.nextToken());
        int failures = Integer.parseInt(strTok.nextToken());
        int skipped = Integer.parseInt(strTok.nextToken());
        boolean isFailure = Boolean.parseBoolean(strTok.nextToken());
        boolean isTimeout = Boolean.parseBoolean(strTok.nextToken());
        return new RunResult(completed, errors, failures, skipped, isFailure, isTimeout);
    }

    public boolean isFailureOrTimeout() {
        return this.timeout || this.failure;
    }

    public boolean isFailure() {
        return this.failure;
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public RunResult aggregate(RunResult other) {
        boolean failure = this.isFailure() || other.isFailure();
        boolean timeout = this.isTimeout() || other.isTimeout();
        int completed = this.getCompletedCount() + other.getCompletedCount();
        int fail = this.getFailures() + other.getFailures();
        int ign = this.getSkipped() + other.getSkipped();
        int err = this.getErrors() + other.getErrors();
        return new RunResult(completed, err, fail, ign, failure, timeout);
    }
}

