/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shadefire.junit;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.maven.surefire.shadefire.common.junit3.JUnit3Reflector;
import org.apache.maven.surefire.shadefire.junit.SurefireTestSet;
import org.apache.maven.surefire.shadefire.junit.TestListenerInvocationHandler;
import org.apache.maven.surefire.shadefire.report.RunListener;
import org.apache.maven.surefire.shadefire.testset.TestSetFailedException;

public final class JUnitTestSet
implements SurefireTestSet {
    private final Class testClass;
    private final JUnit3Reflector reflector;

    public JUnitTestSet(Class testClass, JUnit3Reflector reflector) throws TestSetFailedException {
        if (testClass == null) {
            throw new NullPointerException("testClass is null");
        }
        this.testClass = testClass;
        this.reflector = reflector;
    }

    public void execute(RunListener reporter, ClassLoader loader) throws TestSetFailedException {
        Class testClass = this.getTestClass();
        try {
            Object testObject = this.reflector.constructTestObject(testClass);
            Method runMethod = this.reflector.getTestInterface().isAssignableFrom(testObject.getClass()) ? this.reflector.getTestInterfaceRunMethod() : this.reflector.getRunMethod(this.testClass);
            Object instanceOfTestResult = this.reflector.getTestResultClass().newInstance();
            TestListenerInvocationHandler invocationHandler = new TestListenerInvocationHandler(reporter);
            Object testListener = Proxy.newProxyInstance(loader, this.reflector.getInterfacesImplementedByDynamicProxy(), (InvocationHandler)invocationHandler);
            Object[] addTestListenerParams = new Object[]{testListener};
            this.reflector.getAddListenerMethod().invoke(instanceOfTestResult, addTestListenerParams);
            Object[] runParams = new Object[]{instanceOfTestResult};
            runMethod.invoke(testObject, runParams);
        }
        catch (IllegalArgumentException e) {
            throw new TestSetFailedException(testClass.getName(), e);
        }
        catch (InstantiationException e) {
            throw new TestSetFailedException(testClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new TestSetFailedException(testClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new TestSetFailedException(testClass.getName(), e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            throw new TestSetFailedException("Class is not a JUnit TestCase", e);
        }
    }

    public String getName() {
        return this.testClass.getName();
    }

    Class getTestClass() {
        return this.testClass;
    }
}

