/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shadefire.report;

import java.util.List;
import org.apache.maven.surefire.shadefire.report.ReportEntry;
import org.apache.maven.surefire.shadefire.report.Reporter;

public class MulticastingReporter
implements Reporter {
    private final Reporter[] target;
    private final int size;

    public MulticastingReporter(List target) {
        this.size = target.size();
        this.target = target.toArray(new Reporter[target.size()]);
    }

    public void testSetStarting(ReportEntry report) {
        for (int i = 0; i < this.size; ++i) {
            this.target[i].testSetStarting(report);
        }
    }

    public void testSetCompleted(ReportEntry report) {
        for (int i = 0; i < this.size; ++i) {
            this.target[i].testSetCompleted(report);
        }
    }

    public void testStarting(ReportEntry report) {
        for (int i = 0; i < this.size; ++i) {
            this.target[i].testStarting(report);
        }
    }

    public void testSucceeded(ReportEntry report) {
        for (int i = 0; i < this.size; ++i) {
            this.target[i].testSucceeded(report);
        }
    }

    public void testError(ReportEntry report, String stdOut, String stdErr) {
        for (int i = 0; i < this.size; ++i) {
            this.target[i].testError(report, stdOut, stdErr);
        }
    }

    public void testFailed(ReportEntry report, String stdOut, String stdErr) {
        for (int i = 0; i < this.size; ++i) {
            this.target[i].testFailed(report, stdOut, stdErr);
        }
    }

    public void testSkipped(ReportEntry report) {
        for (int i = 0; i < this.size; ++i) {
            this.target[i].testSkipped(report);
        }
    }

    public void writeMessage(String message) {
        for (int i = 0; i < this.size; ++i) {
            this.target[i].writeMessage(message);
        }
    }

    public void writeMessage(byte[] b, int off, int len) {
        for (int i = 0; i < this.size; ++i) {
            this.target[i].writeMessage(b, off, len);
        }
    }

    public void reset() {
        for (int i = 0; i < this.size; ++i) {
            this.target[i].reset();
        }
    }
}

