/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shadefire.booter;

import java.util.Properties;
import org.apache.maven.surefire.shadefire.booter.DirectoryScannerParametersAware;
import org.apache.maven.surefire.shadefire.booter.ForkingRunListener;
import org.apache.maven.surefire.shadefire.booter.ProviderPropertiesAware;
import org.apache.maven.surefire.shadefire.booter.ReporterConfigurationAware;
import org.apache.maven.surefire.shadefire.booter.RunOrderParametersAware;
import org.apache.maven.surefire.shadefire.booter.SurefireClassLoadersAware;
import org.apache.maven.surefire.shadefire.booter.TestArtifactInfoAware;
import org.apache.maven.surefire.shadefire.booter.TestRequestAware;
import org.apache.maven.surefire.shadefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.shadefire.report.ConsoleLogger;
import org.apache.maven.surefire.shadefire.report.DefaultDirectConsoleReporter;
import org.apache.maven.surefire.shadefire.report.ReporterConfiguration;
import org.apache.maven.surefire.shadefire.report.ReporterFactory;
import org.apache.maven.surefire.shadefire.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.shadefire.testset.RunOrderParameters;
import org.apache.maven.surefire.shadefire.testset.TestArtifactInfo;
import org.apache.maven.surefire.shadefire.testset.TestRequest;
import org.apache.maven.surefire.shadefire.util.DefaultDirectoryScanner;
import org.apache.maven.surefire.shadefire.util.DefaultRunOrderCalculator;
import org.apache.maven.surefire.shadefire.util.DirectoryScanner;
import org.apache.maven.surefire.shadefire.util.RunOrderCalculator;

public class BaseProviderFactory
implements DirectoryScannerParametersAware,
ReporterConfigurationAware,
SurefireClassLoadersAware,
TestRequestAware,
ProviderPropertiesAware,
ProviderParameters,
TestArtifactInfoAware,
RunOrderParametersAware {
    private Properties providerProperties;
    private DirectoryScannerParameters directoryScannerParameters;
    private ReporterConfiguration reporterConfiguration;
    private RunOrderParameters runOrderParameters;
    private ClassLoader testClassLoader;
    private TestRequest testRequest;
    private TestArtifactInfo testArtifactInfo;
    private static final Integer ROOT_CHANNEl = new Integer(0);
    private final ReporterFactory reporterFactory;
    private final boolean insideFork;

    public BaseProviderFactory(ReporterFactory reporterFactory, Boolean insideFork) {
        this.reporterFactory = reporterFactory;
        this.insideFork = insideFork;
    }

    public DirectoryScanner getDirectoryScanner() {
        if (this.directoryScannerParameters == null) {
            return null;
        }
        return new DefaultDirectoryScanner(this.directoryScannerParameters.getTestClassesDirectory(), this.directoryScannerParameters.getIncludes(), this.directoryScannerParameters.getExcludes());
    }

    private int getThreadCount() {
        String threadcount = (String)this.providerProperties.get("threadcount");
        return threadcount == null ? 1 : Integer.parseInt(threadcount);
    }

    public RunOrderCalculator getRunOrderCalculator() {
        if (this.directoryScannerParameters == null) {
            return null;
        }
        return new DefaultRunOrderCalculator(this.runOrderParameters, this.getThreadCount());
    }

    public ReporterFactory getReporterFactory() {
        return this.reporterFactory;
    }

    public void setDirectoryScannerParameters(DirectoryScannerParameters directoryScannerParameters) {
        this.directoryScannerParameters = directoryScannerParameters;
    }

    public void setReporterConfiguration(ReporterConfiguration reporterConfiguration) {
        this.reporterConfiguration = reporterConfiguration;
    }

    public void setClassLoaders(ClassLoader surefireClassLoader, ClassLoader testClassLoader) {
        this.testClassLoader = testClassLoader;
    }

    public ConsoleLogger getConsoleLogger() {
        if (this.insideFork) {
            return new ForkingRunListener(this.reporterConfiguration.getOriginalSystemOut(), ROOT_CHANNEl, this.reporterConfiguration.isTrimStackTrace());
        }
        return new DefaultDirectConsoleReporter(this.reporterConfiguration.getOriginalSystemOut());
    }

    public void setTestRequest(TestRequest testRequest) {
        this.testRequest = testRequest;
    }

    public DirectoryScannerParameters getDirectoryScannerParameters() {
        return this.directoryScannerParameters;
    }

    public ReporterConfiguration getReporterConfiguration() {
        return this.reporterConfiguration;
    }

    public TestRequest getTestRequest() {
        return this.testRequest;
    }

    public ClassLoader getTestClassLoader() {
        return this.testClassLoader;
    }

    public void setProviderProperties(Properties providerProperties) {
        this.providerProperties = providerProperties;
    }

    public Properties getProviderProperties() {
        return this.providerProperties;
    }

    public TestArtifactInfo getTestArtifactInfo() {
        return this.testArtifactInfo;
    }

    public void setTestArtifactInfo(TestArtifactInfo testArtifactInfo) {
        this.testArtifactInfo = testArtifactInfo;
    }

    public void setRunOrderParameters(RunOrderParameters runOrderParameters) {
        this.runOrderParameters = runOrderParameters;
    }
}

