/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.common.junit4.Notifier;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

class JUnitCore {
    private final Notifier notifier;

    JUnitCore(Notifier notifier) {
        this.notifier = notifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result run(Runner runner) throws TestSetFailedException {
        Result result = new Result();
        RunListener listener = result.createListener();
        this.notifier.addFirstListener(listener);
        try {
            this.notifier.fireTestRunStarted(runner.getDescription());
            runner.run((RunNotifier)this.notifier);
        }
        catch (Throwable e) {
            this.afterException(e);
        }
        finally {
            this.notifier.fireTestRunFinished(result);
            this.notifier.removeListener(listener);
            this.afterFinished();
        }
        return result;
    }

    protected void afterException(Throwable e) throws TestSetFailedException {
        throw new TestSetFailedException(e);
    }

    protected void afterFinished() {
    }
}

