/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.io.IOException;
import java.util.Map;
import org.apache.maven.surefire.junitcore.ClassesParallelRunListener;
import org.apache.maven.surefire.junitcore.ConcurrentPrintStream;
import org.apache.maven.surefire.junitcore.MethodsParallelRunListener;
import org.apache.maven.surefire.junitcore.TestMethod;
import org.apache.maven.surefire.junitcore.TestSet;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.testset.TestSetFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConcurrentReporterManager
implements RunListener {
    private final Map<String, TestSet> classMethodCounts;
    private final ReporterConfiguration reporterConfiguration;
    private final ThreadLocal<RunListener> reporterManagerThreadLocal = new ThreadLocal();
    private final boolean reportImmediately;
    private final ConcurrentPrintStream out = new ConcurrentPrintStream(true);
    private final ConcurrentPrintStream err = new ConcurrentPrintStream(false);
    private final ReporterFactory reporterFactory;

    ConcurrentReporterManager(ReporterFactory reporterFactory, boolean reportImmediately, ReporterConfiguration reporterConfiguration, Map<String, TestSet> classMethodCounts) throws TestSetFailedException {
        this.reportImmediately = reportImmediately;
        this.reporterFactory = reporterFactory;
        this.reporterConfiguration = reporterConfiguration;
        this.classMethodCounts = classMethodCounts;
        this.reporterFactory.createReporter();
        System.setOut(this.out);
        System.setErr(this.err);
    }

    public void testSetStarting(ReportEntry description) {
    }

    public void testSetCompleted(ReportEntry result) throws ReporterException {
        for (TestSet testSet : this.classMethodCounts.values()) {
            testSet.replay(this.getReporterManager());
        }
        try {
            this.out.writeTo(this.reporterConfiguration.getOriginalSystemOut());
            this.err.writeTo(this.reporterConfiguration.getOriginalSystemErr());
        }
        catch (IOException e) {
            throw new ReporterException("When writing reports", (Exception)e);
        }
    }

    public void testFailed(ReportEntry failure) {
        this.getOrCreateTestMethod(failure).testFailure(failure);
    }

    public void testError(ReportEntry failure) {
        this.getOrCreateTestMethod(failure).testError(failure);
    }

    public void testSkipped(ReportEntry description) {
        TestSet testSet = this.getTestSet(description);
        TestMethod testMethod = this.getTestSet(description).createTestMethod(description);
        testMethod.testIgnored(description);
        testSet.incrementFinishedTests(this.getReporterManager(), this.reportImmediately);
    }

    public void testAssumptionFailure(ReportEntry failure) {
        this.getOrCreateTestMethod(failure).testIgnored(failure);
    }

    public void testStarting(ReportEntry description) {
        TestSet testSet = this.getTestSet(description);
        TestMethod testMethod = testSet.createTestMethod(description);
        testMethod.attachToThread();
        this.checkIfTestSetCanBeReported(testSet);
        testSet.attachToThread();
    }

    public void testSucceeded(ReportEntry report) {
        this.getTestMethod().testFinished();
        TestSet.getThreadTestSet().incrementFinishedTests(this.getReporterManager(), this.reportImmediately);
        this.detachTestMethodFromThread();
    }

    private TestMethod getOrCreateTestMethod(ReportEntry description) {
        TestMethod threadTestMethod = TestMethod.getThreadTestMethod();
        if (threadTestMethod != null) {
            return threadTestMethod;
        }
        TestSet testSet = this.getTestSet(description);
        return testSet.createTestMethod(description);
    }

    protected abstract void checkIfTestSetCanBeReported(TestSet var1);

    TestMethod getTestMethod() {
        return TestMethod.getThreadTestMethod();
    }

    void detachTestMethodFromThread() {
        TestMethod.detachFromCurrentThread();
    }

    TestSet getTestSet(ReportEntry description) {
        return this.classMethodCounts.get(description.getSourceName());
    }

    RunListener getReporterManager() {
        RunListener reporterManager = this.reporterManagerThreadLocal.get();
        if (reporterManager == null) {
            reporterManager = this.reporterFactory.createReporter();
            this.reporterManagerThreadLocal.set(reporterManager);
        }
        return reporterManager;
    }

    public static ConcurrentReporterManager createInstance(Map<String, TestSet> classMethodCounts, ReporterFactory reporterManagerFactory, ReporterConfiguration reporterConfiguration, boolean parallelClasses, boolean parallelBoth) throws TestSetFailedException {
        if (parallelClasses) {
            return new ClassesParallelRunListener(classMethodCounts, reporterManagerFactory, reporterConfiguration);
        }
        return new MethodsParallelRunListener(classMethodCounts, reporterManagerFactory, reporterConfiguration, !parallelBoth);
    }
}

