/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.surefire.NonAbstractClassFilter;
import org.apache.maven.surefire.junitcore.ConcurrentReportingRunListener;
import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.junitcore.JUnitCoreWrapper;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.DirectoryScanner;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;
import org.junit.runner.notification.RunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitCoreProvider
implements SurefireProvider {
    private final ReporterFactory reporterFactory;
    private final ClassLoader testClassLoader;
    private final DirectoryScanner directoryScanner;
    private final JUnitCoreParameters jUnitCoreParameters;
    private final NonAbstractClassFilter scannerFilter;
    private final List<RunListener> customRunListeners;
    private TestsToRun testsToRun;
    private final ReporterConfiguration reporterConfiguration;

    public JUnitCoreProvider(ProviderParameters booterParameters) {
        this.reporterFactory = booterParameters.getReporterFactory();
        this.reporterConfiguration = booterParameters.getReporterConfiguration();
        this.testClassLoader = booterParameters.getTestClassLoader();
        this.directoryScanner = booterParameters.getDirectoryScanner();
        this.jUnitCoreParameters = new JUnitCoreParameters(booterParameters.getProviderProperties());
        this.scannerFilter = new NonAbstractClassFilter();
        this.customRunListeners = this.createCustomListeners(booterParameters.getProviderProperties().getProperty("listener"));
    }

    public Boolean isRunnable() {
        return Boolean.TRUE;
    }

    public Iterator getSuites() {
        this.testsToRun = this.scanClassPath();
        return this.testsToRun.iterator();
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        String message = "Concurrency config is " + this.jUnitCoreParameters.toString();
        this.reporterFactory.createReporter().writeMessage(message);
        if (this.testsToRun == null) {
            this.testsToRun = forkTestSet == null ? this.scanClassPath() : TestsToRun.fromClass((Class)((Class)forkTestSet));
        }
        ConcurrentReportingRunListener listener = ConcurrentReportingRunListener.createInstance(this.reporterFactory, this.reporterConfiguration, this.jUnitCoreParameters.isParallelClasses(), this.jUnitCoreParameters.isParallelBoth());
        this.customRunListeners.add(0, listener);
        JUnitCoreWrapper.execute(this.testsToRun, this.jUnitCoreParameters, this.customRunListeners);
        return this.reporterFactory.close();
    }

    private TestsToRun scanClassPath() {
        return this.directoryScanner.locateTestClasses(this.testClassLoader, (ScannerFilter)this.scannerFilter);
    }

    private List<RunListener> createCustomListeners(String listenerProperty) {
        LinkedList<RunListener> result = new LinkedList<RunListener>();
        if (listenerProperty == null) {
            return result;
        }
        for (String thisListenerName : listenerProperty.split(",")) {
            RunListener customRunListener = (RunListener)ReflectionUtils.instantiate((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)thisListenerName);
            result.add(customRunListener);
        }
        return result;
    }
}

