/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.surefire.junitcore.TestMethod;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterManager;
import org.junit.runner.Description;

public class TestSet {
    private static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.maven.surefire.surefire");
    private final Description testSetDescription;
    private AtomicInteger numberOfCompletedChildren = new AtomicInteger(0);
    private final AtomicInteger numberOfTests = new AtomicInteger(0);
    private final List<TestMethod> testMethods = Collections.synchronizedList(new ArrayList());
    private static final InheritableThreadLocal<TestSet> testSet = new InheritableThreadLocal();
    private AtomicBoolean allScheduled = new AtomicBoolean();
    private AtomicBoolean played = new AtomicBoolean();

    public TestSet(Description testSetDescription) {
        this.testSetDescription = testSetDescription;
    }

    public void replay(ReporterManager target) {
        if (!this.played.compareAndSet(false, true)) {
            return;
        }
        try {
            ReportEntry report = this.createReportEntry("testSetStarting");
            target.testSetStarting(report);
            for (TestMethod testMethod : this.testMethods) {
                testMethod.replay(target);
            }
            report = this.createReportEntry("testSetCompletedNormally");
            target.testSetCompleted(report);
            target.reset();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TestMethod createTestMethod(Description description) {
        TestMethod testMethod = new TestMethod(description);
        this.addTestMethod(testMethod);
        return testMethod;
    }

    private ReportEntry createReportEntry(String rawString2) {
        String rawString = bundle.getString(rawString2);
        boolean isJunit3 = this.testSetDescription.getTestClass() == null;
        String classNameToUse = isJunit3 ? ((Description)this.testSetDescription.getChildren().get(0)).getClassName() : this.testSetDescription.getClassName();
        return new ReportEntry(classNameToUse, classNameToUse, rawString);
    }

    public void incrementTestMethodCount() {
        this.numberOfTests.incrementAndGet();
    }

    public void addTestMethod(TestMethod testMethod) {
        this.testMethods.add(testMethod);
    }

    public void incrementFinishedTests(ReporterManager reporterManager, boolean reportImmediately) {
        this.numberOfCompletedChildren.incrementAndGet();
        if (this.allScheduled.get() && this.isAllTestsDone() && reportImmediately) {
            this.replay(reporterManager);
        }
    }

    public void setAllScheduled(ReporterManager reporterManager) {
        this.allScheduled.set(true);
        if (this.isAllTestsDone()) {
            this.replay(reporterManager);
        }
    }

    private boolean isAllTestsDone() {
        return this.testMethods.size() == this.numberOfCompletedChildren.get();
    }

    public void attachToThread() {
        testSet.set(this);
    }

    public static TestSet getThreadTestSet() {
        return (TestSet)testSet.get();
    }
}

