/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.surefire.junitcore.JUnitCoreStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

class JUnitCoreTestSetReporter
extends RunListener {
    private static final Pattern PARENS = Pattern.compile("^[^\\(\\)]+\\(([^\\\\(\\\\)]+)\\)$");
    private static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.maven.surefire.surefire");
    private Description currentRunStart;
    private String currentClassName;
    private ReporterManager reportMgr;
    private boolean failureFlag;

    JUnitCoreTestSetReporter(ReporterManager reportManager) {
        this.reportMgr = reportManager;
    }

    public void testRunStarted(Description description) throws Exception {
        String rawString = bundle.getString("testSetStarting");
        this.currentClassName = this.extractClassName(description);
        this.currentRunStart = description;
        ReportEntry report = new ReportEntry(description.getClassName(), this.currentClassName, rawString);
        this.reportMgr.testSetStarting(report);
    }

    public void testRunFinished(Result result) throws Exception {
        String rawString = bundle.getString("testSetCompletedNormally");
        ReportEntry report = new ReportEntry(this.currentRunStart.getClassName(), this.currentClassName, rawString);
        this.reportMgr.testSetCompleted(report);
        this.reportMgr.reset();
    }

    public void testIgnored(Description description) throws Exception {
        String rawString = bundle.getString("testSkipped");
        ReportEntry report = new ReportEntry(description.getTestClass().getCanonicalName(), description.getDisplayName(), rawString);
        this.reportMgr.testSkipped(report);
    }

    public void testStarted(Description description) throws Exception {
        String rawString = bundle.getString("testStarting");
        ReportEntry report = new ReportEntry(description.getTestClass().getCanonicalName(), description.getDisplayName(), rawString);
        this.reportMgr.testStarting(report);
        this.failureFlag = false;
    }

    public void testFailure(Failure failure) throws Exception {
        String rawString = bundle.getString("executeException");
        ReportEntry report = new ReportEntry(failure.getDescription().getTestClass().getCanonicalName(), failure.getTestHeader(), rawString, (StackTraceWriter)new JUnitCoreStackTraceWriter(failure));
        if (failure.getException() instanceof AssertionError) {
            this.reportMgr.testFailed(report);
        } else {
            this.reportMgr.testError(report);
        }
        this.failureFlag = true;
    }

    public void testFinished(Description description) throws Exception {
        if (!this.failureFlag) {
            String rawString = bundle.getString("testSuccessful");
            ReportEntry report = new ReportEntry(description.getTestClass().getCanonicalName(), description.getDisplayName(), rawString);
            this.reportMgr.testSucceeded(report);
        }
    }

    private String extractClassName(Description description) {
        String displayName = description.getDisplayName();
        Matcher m = PARENS.matcher(displayName);
        if (!m.find()) {
            return displayName;
        }
        return m.group(1);
    }
}

