/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Map;
import org.apache.maven.surefire.junitcore.ClassDemarcatingRunner;
import org.apache.maven.surefire.junitcore.ClassesParallelRunListener;
import org.apache.maven.surefire.junitcore.LogicalStream;
import org.apache.maven.surefire.junitcore.MethodsParallelRunListener;
import org.apache.maven.surefire.junitcore.TestMethod;
import org.apache.maven.surefire.junitcore.TestSet;
import org.apache.maven.surefire.report.ConsoleLogger;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.testset.TestSetFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConcurrentReporterManager
implements RunListener,
ConsoleOutputReceiver {
    private final Map<String, TestSet> classMethodCounts;
    private final ThreadLocal<RunListener> reporterManagerThreadLocal = new ThreadLocal();
    private final boolean reportImmediately;
    private final ReporterFactory reporterFactory;
    private final ConsoleLogger consoleLogger;

    ConcurrentReporterManager(ReporterFactory reporterFactory, ConsoleLogger consoleLogger, boolean reportImmediately, Map<String, TestSet> classMethodCounts) throws TestSetFailedException {
        this.reportImmediately = reportImmediately;
        this.reporterFactory = reporterFactory;
        this.classMethodCounts = classMethodCounts;
        this.consoleLogger = consoleLogger;
    }

    public void testSetStarting(ReportEntry description) {
    }

    public void testSetCompleted(ReportEntry result) {
        RunListener reporterManager = this.getRunListener();
        for (TestSet testSet : this.classMethodCounts.values()) {
            testSet.replay(reporterManager);
        }
    }

    public void testFailed(ReportEntry failure) {
        this.getOrCreateTestMethod(failure).testFailure(failure);
    }

    public void testError(ReportEntry failure) {
        TestMethod testMethod = this.getOrCreateTestMethod(failure);
        if (testMethod != null) {
            testMethod.testError(failure);
        }
    }

    public void testSkipped(ReportEntry description) {
        TestSet testSet = this.getTestSet(description);
        TestMethod testMethod = this.getTestSet(description).createTestMethod(description);
        testMethod.testIgnored(description);
        testSet.incrementFinishedTests(this.getRunListener(), this.reportImmediately);
    }

    public void testAssumptionFailure(ReportEntry failure) {
        this.getOrCreateTestMethod(failure).testIgnored(failure);
    }

    public void testStarting(ReportEntry description) {
        TestSet testSet = this.getTestSet(description);
        TestMethod testMethod = testSet.createTestMethod(description);
        testMethod.attachToThread();
        this.checkIfTestSetCanBeReported(testSet);
        testSet.attachToThread();
    }

    public void testSucceeded(ReportEntry report) {
        this.getTestMethod().testFinished();
        TestSet.getThreadTestSet().incrementFinishedTests(this.getRunListener(), this.reportImmediately);
        this.detachTestMethodFromThread();
    }

    private TestMethod getOrCreateTestMethod(ReportEntry description) {
        TestMethod threadTestMethod = TestMethod.getThreadTestMethod();
        if (threadTestMethod != null) {
            return threadTestMethod;
        }
        TestSet testSet = this.getTestSet(description);
        if (testSet == null) {
            this.consoleLogger.info(description.getName());
            this.consoleLogger.info(description.getStackTraceWriter().writeTraceToString());
            return null;
        }
        return testSet.createTestMethod(description);
    }

    protected abstract void checkIfTestSetCanBeReported(TestSet var1);

    TestMethod getTestMethod() {
        return TestMethod.getThreadTestMethod();
    }

    void detachTestMethodFromThread() {
        TestMethod.detachFromCurrentThread();
    }

    TestSet getTestSet(ReportEntry description) {
        TestSet testSet = this.classMethodCounts.get(description.getSourceName());
        if (testSet == null) {
            testSet = this.classMethodCounts.get(ClassDemarcatingRunner.getCurrentTestClass());
        }
        return testSet;
    }

    RunListener getRunListener() {
        RunListener runListener = this.reporterManagerThreadLocal.get();
        if (runListener == null) {
            runListener = this.reporterFactory.createReporter();
            this.reporterManagerThreadLocal.set(runListener);
        }
        return runListener;
    }

    public static ConcurrentReporterManager createInstance(Map<String, TestSet> classMethodCounts, ReporterFactory reporterManagerFactory, boolean parallelClasses, boolean parallelBoth, ConsoleLogger consoleLogger) throws TestSetFailedException {
        if (parallelClasses) {
            return new ClassesParallelRunListener(classMethodCounts, reporterManagerFactory, consoleLogger);
        }
        return new MethodsParallelRunListener(classMethodCounts, reporterManagerFactory, !parallelBoth, consoleLogger);
    }

    public void writeTestOutput(byte[] buf, int off, int len, boolean stdout) {
        TestMethod threadTestMethod = TestMethod.getThreadTestMethod();
        if (threadTestMethod != null) {
            LogicalStream logicalStream = threadTestMethod.getLogicalStream();
            logicalStream.write(stdout, buf, off, len);
        } else {
            TestSet testSet;
            String currentTestClassName = ClassDemarcatingRunner.getCurrentTestClass();
            TestSet testSet2 = testSet = currentTestClassName != null ? this.classMethodCounts.get(currentTestClassName) : null;
            if (testSet != null) {
                testSet.getClassLevelLogicalStream().write(stdout, buf, off, len);
            } else {
                this.consoleLogger.info(new String(buf, off, len));
            }
        }
    }
}

