/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.extensions.util;

import java.io.Closeable;
import org.apache.maven.surefire.extensions.util.CommandlineStreams;
import org.apache.maven.surefire.extensions.util.CountdownCloseable;
import org.apache.maven.surefire.shared.utils.cli.CommandLineException;
import org.apache.maven.surefire.shared.utils.cli.Commandline;
import org.apache.maven.surefire.shared.utils.cli.ShutdownHookUtils;

public class CommandlineExecutor
implements Closeable {
    private final Commandline cli;
    private final CountdownCloseable endOfStreamsCountdown;
    private Process process;
    private Thread shutdownHook;

    public CommandlineExecutor(Commandline cli, CountdownCloseable endOfStreamsCountdown) {
        this.cli = cli;
        this.endOfStreamsCountdown = endOfStreamsCountdown;
    }

    public CommandlineStreams execute() throws CommandLineException {
        this.process = this.cli.execute();
        this.shutdownHook = new ProcessHook(this.process);
        ShutdownHookUtils.addShutDownHook((Thread)this.shutdownHook);
        return new CommandlineStreams(this.process);
    }

    public int awaitExit() throws InterruptedException {
        try {
            int n = this.process.waitFor();
            return n;
        }
        finally {
            this.endOfStreamsCountdown.awaitClosed();
        }
    }

    @Override
    public void close() {
        if (this.shutdownHook != null) {
            this.shutdownHook.run();
            ShutdownHookUtils.removeShutdownHook((Thread)this.shutdownHook);
            this.shutdownHook = null;
        }
    }

    private static class ProcessHook
    extends Thread {
        private final Process process;

        private ProcessHook(Process process) {
            super("cli-shutdown-hook");
            this.process = process;
            this.setContextClassLoader(null);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            this.process.destroy();
        }
    }
}

