/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.surefire.booter.BooterConstants;
import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.PropertiesWrapper;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.testset.TestArtifactInfo;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.surefire.util.internal.StringUtils;

public class BooterDeserializer
implements BooterConstants {
    final PropertiesWrapper properties;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$io$File;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$Properties;

    public BooterDeserializer(InputStream inputStream) throws IOException {
        this.properties = SystemPropertyManager.loadProperties(inputStream);
    }

    public ProviderConfiguration deserialize() throws IOException {
        File reportsDirectory = new File(this.properties.getProperty("reportsDirectory"));
        String testNgVersion = this.properties.getProperty("testFwJarVersion");
        String testArtifactClassifier = this.properties.getProperty("testFwJarClassifier");
        Object testForFork = this.properties.getTypeDecoded("forkTestSet");
        String requestedTest = this.properties.getProperty("requestedTest");
        File sourceDirectory = (File)BooterDeserializer.getParamValue(this.properties.getProperty("testSuiteDefinitionTestSourceDirectory"), (class$java$io$File == null ? (class$java$io$File = BooterDeserializer.class$("java.io.File")) : class$java$io$File).getName());
        List reports = this.properties.getStringList("report.");
        List excludesList = this.properties.getStringList("excludes");
        List includesList = this.properties.getStringList("includes");
        List testSuiteXmlFiles = this.properties.getStringList("testSuiteXmlFiles");
        File testClassesDirectory = this.properties.getFileProperty("testClassesDirectory");
        String runOrder = this.properties.getProperty("runOrder");
        DirectoryScannerParameters dirScannerParams = new DirectoryScannerParameters(testClassesDirectory, includesList, excludesList, this.valueOf(this.properties.getBooleanProperty("failIfNoTests")), runOrder);
        TestArtifactInfo testNg = new TestArtifactInfo(testNgVersion, testArtifactClassifier);
        TestRequest testSuiteDefinition = new TestRequest(testSuiteXmlFiles, sourceDirectory, requestedTest);
        ReporterConfiguration reporterConfiguration = new ReporterConfiguration(reports, reportsDirectory, this.valueOf(this.properties.getBooleanProperty("isTrimStackTrace")));
        return new ProviderConfiguration(dirScannerParams, this.properties.getBooleanProperty("failIfNoTests"), reporterConfiguration, testNg, testSuiteDefinition, this.properties.getProperties(), testForFork);
    }

    public StartupConfiguration getProviderConfiguration() throws IOException {
        boolean enableAssertions = this.properties.getBooleanProperty("enableAssertions");
        boolean childDelegation = this.properties.getBooleanProperty("childDelegation");
        boolean useSystemClassLoader = this.properties.getBooleanProperty("useSystemClassLoader");
        boolean useManifestOnlyJar = this.properties.getBooleanProperty("useManifestOnlyJar");
        String providerConfiguration = this.properties.getProperty("providerConfiguration");
        List classpath = this.properties.getStringList("classPathUrl.");
        List sureFireClasspath = this.properties.getStringList("surefireClassPathUrl.");
        ClassLoaderConfiguration classLoaderConfiguration = new ClassLoaderConfiguration(useSystemClassLoader, useManifestOnlyJar);
        ClasspathConfiguration classpathConfiguration = new ClasspathConfiguration(classpath, sureFireClasspath, enableAssertions, childDelegation);
        return StartupConfiguration.inForkedVm(providerConfiguration, classpathConfiguration, classLoaderConfiguration);
    }

    private Boolean valueOf(boolean aBoolean) {
        return aBoolean ? Boolean.TRUE : Boolean.FALSE;
    }

    private static List processStringList(String stringList) {
        String sl = stringList;
        if (sl.startsWith("[") && sl.endsWith("]")) {
            sl = sl.substring(1, sl.length() - 1);
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = StringUtils.split((String)sl, (String)",");
        for (int i = 0; i < stringArray.length; ++i) {
            list.add(stringArray[i].trim());
        }
        return list;
    }

    private static Object[] constructParamObjects(String paramProperty, Class typeProperty) {
        Object[] paramObjects = null;
        if (paramProperty != null) {
            String[] params = StringUtils.split((String)StringUtils.replace((String)StringUtils.replace((String)paramProperty, (String)"||", (String)"| |"), (String)"||", (String)"| |"), (String)"|");
            paramObjects = new Object[params.length];
            String typeName = typeProperty.getName();
            for (int i = 0; i < params.length; ++i) {
                String param = params[i];
                paramObjects[i] = BooterDeserializer.getParamValue(param, typeName);
            }
        }
        return paramObjects;
    }

    private static Object getParamValue(String param, String typeName) {
        if (typeName.trim().length() == 0) {
            return null;
        }
        if (typeName.equals((class$java$lang$String == null ? (class$java$lang$String = BooterDeserializer.class$("java.lang.String")) : class$java$lang$String).getName())) {
            return param;
        }
        if (typeName.equals((class$java$io$File == null ? (class$java$io$File = BooterDeserializer.class$("java.io.File")) : class$java$io$File).getName())) {
            return new File(param);
        }
        if (typeName.equals((array$Ljava$io$File == null ? (array$Ljava$io$File = BooterDeserializer.class$("[Ljava.io.File;")) : array$Ljava$io$File).getName())) {
            List stringList = BooterDeserializer.processStringList(param);
            File[] fileList = new File[stringList.size()];
            for (int j = 0; j < stringList.size(); ++j) {
                fileList[j] = new File((String)stringList.get(j));
            }
            return fileList;
        }
        if (typeName.equals((class$java$util$ArrayList == null ? (class$java$util$ArrayList = BooterDeserializer.class$("java.util.ArrayList")) : class$java$util$ArrayList).getName())) {
            return BooterDeserializer.processStringList(param);
        }
        if (typeName.equals((class$java$lang$Boolean == null ? (class$java$lang$Boolean = BooterDeserializer.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName())) {
            return Boolean.valueOf(param);
        }
        if (typeName.equals((class$java$lang$Integer == null ? (class$java$lang$Integer = BooterDeserializer.class$("java.lang.Integer")) : class$java$lang$Integer).getName())) {
            return Integer.valueOf(param);
        }
        if (typeName.equals((class$java$util$Properties == null ? (class$java$util$Properties = BooterDeserializer.class$("java.util.Properties")) : class$java$util$Properties).getName())) {
            Properties result = new Properties();
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(param.getBytes("8859_1"));
                result.load(bais);
            }
            catch (Exception e) {
                throw new RuntimeException("bug in property conversion", e);
            }
            return result;
        }
        throw new IllegalArgumentException("Unknown parameter type: " + typeName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

