/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.report.SafeThrowable;
import org.apache.maven.surefire.report.SmartStackTraceParser;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.junit.runner.notification.Failure;

public class JUnit4StackTraceWriter
implements StackTraceWriter {
    protected final Failure junitFailure;

    public JUnit4StackTraceWriter(Failure junitFailure) {
        this.junitFailure = junitFailure;
    }

    public String writeTraceToString() {
        return this.junitFailure.getTrace();
    }

    protected String getTestClassName() {
        return JUnit4RunListener.extractClassName(this.junitFailure.getDescription());
    }

    public String smartTrimmedStackTrace() {
        Throwable exception = this.junitFailure.getException();
        if (exception != null) {
            SmartStackTraceParser smartStackTraceParser = new SmartStackTraceParser(this.getTestClassName(), exception);
            return smartStackTraceParser.getString();
        }
        return this.junitFailure.getMessage();
    }

    public String writeTrimmedTraceToString() {
        String testClass = this.getTestClassName();
        try {
            return SmartStackTraceParser.innerMostWithFocusOnClass((Throwable)this.junitFailure.getException(), (String)testClass);
        }
        catch (Throwable t) {
            return SmartStackTraceParser.innerMostWithFocusOnClass((Throwable)t, (String)testClass);
        }
    }

    public SafeThrowable getThrowable() {
        return new SafeThrowable(this.junitFailure.getException());
    }
}

