/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectSorter;
import org.apache.maven.shared.runtime.MavenRuntimeException;
import org.apache.maven.shared.runtime.MavenRuntimeVisitor;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XMLMavenRuntimeVisitor
implements MavenRuntimeVisitor {
    private final List<MavenProject> projects = new ArrayList<MavenProject>();

    @Override
    public void visitProjectProperties(URL url) throws MavenRuntimeException {
    }

    @Override
    public void visitProjectXML(URL url) throws MavenRuntimeException {
        MavenProject project = this.parseProjectXML(url);
        this.projects.add(project);
    }

    public List<MavenProject> getProjects() {
        return Collections.unmodifiableList(this.projects);
    }

    public List<MavenProject> getSortedProjects() throws MavenRuntimeException {
        try {
            ProjectSorter projectSorter = new ProjectSorter(this.projects);
            return XMLMavenRuntimeVisitor.genericList(projectSorter.getSortedProjects(), MavenProject.class);
        }
        catch (CycleDetectedException exception) {
            throw new MavenRuntimeException("Cannot sort projects", exception);
        }
        catch (DuplicateProjectException exception) {
            throw new MavenRuntimeException("Cannot sort projects", exception);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MavenProject parseProjectXML(URL url) throws MavenRuntimeException {
        MavenProject mavenProject;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        InputStream in = null;
        try {
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            in = connection.getInputStream();
            Model model = reader.read((Reader)ReaderFactory.newXmlReader((InputStream)in));
            mavenProject = new MavenProject(model);
        }
        catch (XmlPullParserException exception) {
            try {
                throw new MavenRuntimeException("Cannot read project XML", exception);
                catch (IOException exception2) {
                    throw new MavenRuntimeException("Cannot read project XML", exception2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)in);
        return mavenProject;
    }

    private static <T> List<T> genericList(List<?> list, Class<T> type) {
        ArrayList<T> genericList = new ArrayList<T>();
        for (Object element : list) {
            genericList.add(type.cast(element));
        }
        return genericList;
    }
}

