/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;

public class ProjectDependencyAnalysis {
    private final Set<Artifact> usedDeclaredArtifacts;
    private final Map<Artifact, Set<String>> usedUndeclaredArtifacts;
    private final Set<Artifact> unusedDeclaredArtifacts;
    private final Set<Artifact> testArtifactsWithNonTestScope;

    public ProjectDependencyAnalysis() {
        this(null, (Map<Artifact, Set<String>>)null, null, null);
    }

    public ProjectDependencyAnalysis(Set<Artifact> usedDeclaredArtifacts, Set<Artifact> usedUndeclaredArtifacts, Set<Artifact> unusedDeclaredArtifacts) {
        this(usedDeclaredArtifacts, usedUndeclaredArtifacts, unusedDeclaredArtifacts, Collections.emptySet());
    }

    public ProjectDependencyAnalysis(Set<Artifact> usedDeclaredArtifacts, Set<Artifact> usedUndeclaredArtifacts, Set<Artifact> unusedDeclaredArtifacts, Set<Artifact> testArtifactsWithNonTestScope) {
        this(usedDeclaredArtifacts, ProjectDependencyAnalysis.mapWithKeys(usedUndeclaredArtifacts), unusedDeclaredArtifacts, testArtifactsWithNonTestScope);
    }

    public ProjectDependencyAnalysis(Set<Artifact> usedDeclaredArtifacts, Map<Artifact, Set<String>> usedUndeclaredArtifacts, Set<Artifact> unusedDeclaredArtifacts, Set<Artifact> testArtifactsWithNonTestScope) {
        this.usedDeclaredArtifacts = this.safeCopy(usedDeclaredArtifacts);
        this.usedUndeclaredArtifacts = ProjectDependencyAnalysis.safeCopy(usedUndeclaredArtifacts);
        this.unusedDeclaredArtifacts = this.safeCopy(unusedDeclaredArtifacts);
        this.testArtifactsWithNonTestScope = this.safeCopy(testArtifactsWithNonTestScope);
    }

    public Set<Artifact> getUsedDeclaredArtifacts() {
        return this.safeCopy(this.usedDeclaredArtifacts);
    }

    public Set<Artifact> getUsedUndeclaredArtifacts() {
        return this.safeCopy(this.usedUndeclaredArtifacts.keySet());
    }

    public Map<Artifact, Set<String>> getUsedUndeclaredArtifactsWithClasses() {
        return ProjectDependencyAnalysis.safeCopy(this.usedUndeclaredArtifacts);
    }

    public Set<Artifact> getUnusedDeclaredArtifacts() {
        return this.safeCopy(this.unusedDeclaredArtifacts);
    }

    public Set<Artifact> getTestArtifactsWithNonTestScope() {
        return this.safeCopy(this.testArtifactsWithNonTestScope);
    }

    public ProjectDependencyAnalysis ignoreNonCompile() {
        HashSet<Artifact> filteredUnusedDeclared = new HashSet<Artifact>(this.unusedDeclaredArtifacts);
        filteredUnusedDeclared.removeIf(artifact -> !artifact.getScope().equals("compile"));
        return new ProjectDependencyAnalysis(this.usedDeclaredArtifacts, this.usedUndeclaredArtifacts, filteredUnusedDeclared, this.testArtifactsWithNonTestScope);
    }

    public ProjectDependencyAnalysis forceDeclaredDependenciesUsage(String[] forceUsedDependencies) throws ProjectDependencyAnalyzerException {
        HashSet<String> forced = new HashSet<String>(Arrays.asList(forceUsedDependencies));
        HashSet<Artifact> forcedUnusedDeclared = new HashSet<Artifact>(this.unusedDeclaredArtifacts);
        HashSet<Artifact> forcedUsedDeclared = new HashSet<Artifact>(this.usedDeclaredArtifacts);
        Iterator iter = forcedUnusedDeclared.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (!forced.remove(artifact.getGroupId() + ':' + artifact.getArtifactId())) continue;
            iter.remove();
            forcedUsedDeclared.add(artifact);
        }
        if (!forced.isEmpty()) {
            HashSet<String> used = new HashSet<String>();
            for (Artifact artifact : this.usedDeclaredArtifacts) {
                String id = artifact.getGroupId() + ':' + artifact.getArtifactId();
                if (!forced.remove(id)) continue;
                used.add(id);
            }
            StringBuilder builder = new StringBuilder();
            if (!forced.isEmpty()) {
                builder.append("not declared: ").append(forced);
            }
            if (!used.isEmpty()) {
                if (builder.length() > 0) {
                    builder.append(" and ");
                }
                builder.append("declared but already detected as used: ").append(used);
            }
            throw new ProjectDependencyAnalyzerException("Trying to force use of dependencies which are " + builder);
        }
        return new ProjectDependencyAnalysis(forcedUsedDeclared, this.usedUndeclaredArtifacts, forcedUnusedDeclared, this.testArtifactsWithNonTestScope);
    }

    public int hashCode() {
        int hashCode = this.getUsedDeclaredArtifacts().hashCode();
        hashCode = hashCode * 37 + this.getUsedUndeclaredArtifacts().hashCode();
        hashCode = hashCode * 37 + this.getUnusedDeclaredArtifacts().hashCode();
        hashCode = hashCode * 37 + this.getTestArtifactsWithNonTestScope().hashCode();
        return hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof ProjectDependencyAnalysis) {
            ProjectDependencyAnalysis analysis = (ProjectDependencyAnalysis)object;
            return this.getUsedDeclaredArtifacts().equals(analysis.getUsedDeclaredArtifacts()) && this.getUsedUndeclaredArtifacts().equals(analysis.getUsedUndeclaredArtifacts()) && this.getUnusedDeclaredArtifacts().equals(analysis.getUnusedDeclaredArtifacts()) && this.getTestArtifactsWithNonTestScope().equals(analysis.getTestArtifactsWithNonTestScope());
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (!this.getUsedDeclaredArtifacts().isEmpty()) {
            buffer.append("usedDeclaredArtifacts=").append(this.getUsedDeclaredArtifacts());
        }
        if (!this.getUsedUndeclaredArtifacts().isEmpty()) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append("usedUndeclaredArtifacts=").append(this.getUsedUndeclaredArtifacts());
        }
        if (!this.getUnusedDeclaredArtifacts().isEmpty()) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append("unusedDeclaredArtifacts=").append(this.getUnusedDeclaredArtifacts());
        }
        if (!this.getTestArtifactsWithNonTestScope().isEmpty()) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append("testArtifactsWithNonTestScope=").append(this.getTestArtifactsWithNonTestScope());
        }
        buffer.insert(0, "[");
        buffer.insert(0, this.getClass().getName());
        buffer.append("]");
        return buffer.toString();
    }

    private Set<Artifact> safeCopy(Set<Artifact> set) {
        return set == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<Artifact>(set));
    }

    private static Map<Artifact, Set<String>> safeCopy(Map<Artifact, Set<String>> origMap) {
        if (origMap == null) {
            return Collections.emptyMap();
        }
        HashMap<Artifact, Set<String>> map = new HashMap<Artifact, Set<String>>();
        for (Map.Entry<Artifact, Set<String>> e : origMap.entrySet()) {
            map.put(e.getKey(), Collections.unmodifiableSet(new LinkedHashSet(e.getValue())));
        }
        return map;
    }

    private static Map<Artifact, Set<String>> mapWithKeys(Set<Artifact> keys) {
        if (keys == null) {
            return Collections.emptyMap();
        }
        HashMap<Artifact, Set<String>> map = new HashMap<Artifact, Set<String>>();
        for (Artifact k : keys) {
            map.put(k, Collections.emptySet());
        }
        return map;
    }
}

