/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.analyzer.ClassAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ClassesPatterns;
import org.apache.maven.shared.dependency.analyzer.DependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;

@Named
@Singleton
public class DefaultProjectDependencyAnalyzer
implements ProjectDependencyAnalyzer {
    @Inject
    private ClassAnalyzer classAnalyzer;
    @Inject
    private DependencyAnalyzer dependencyAnalyzer;

    @Override
    public ProjectDependencyAnalysis analyze(MavenProject project, Collection<String> excludedClasses) throws ProjectDependencyAnalyzerException {
        try {
            ClassesPatterns excludedClassesPatterns = new ClassesPatterns(excludedClasses);
            Map<Artifact, Set<String>> artifactClassMap = this.buildArtifactClassMap(project, excludedClassesPatterns);
            Set<String> mainDependencyClasses = this.buildMainDependencyClasses(project, excludedClassesPatterns);
            Set<String> testDependencyClasses = this.buildTestDependencyClasses(project, excludedClassesPatterns);
            HashSet<String> dependencyClasses = new HashSet<String>();
            dependencyClasses.addAll(mainDependencyClasses);
            dependencyClasses.addAll(testDependencyClasses);
            Set<String> testOnlyDependencyClasses = DefaultProjectDependencyAnalyzer.buildTestOnlyDependencyClasses(mainDependencyClasses, testDependencyClasses);
            Map<Artifact, Set<String>> usedArtifacts = DefaultProjectDependencyAnalyzer.buildUsedArtifacts(artifactClassMap, dependencyClasses);
            Set<Artifact> mainUsedArtifacts = DefaultProjectDependencyAnalyzer.buildUsedArtifacts(artifactClassMap, mainDependencyClasses).keySet();
            Set<Artifact> testArtifacts = DefaultProjectDependencyAnalyzer.buildUsedArtifacts(artifactClassMap, testOnlyDependencyClasses).keySet();
            Set<Artifact> testOnlyArtifacts = DefaultProjectDependencyAnalyzer.removeAll(testArtifacts, mainUsedArtifacts);
            Set<Artifact> declaredArtifacts = DefaultProjectDependencyAnalyzer.buildDeclaredArtifacts(project);
            LinkedHashSet<Artifact> usedDeclaredArtifacts = new LinkedHashSet<Artifact>(declaredArtifacts);
            usedDeclaredArtifacts.retainAll(usedArtifacts.keySet());
            LinkedHashMap<Artifact, Set<String>> usedUndeclaredArtifactsWithClasses = new LinkedHashMap<Artifact, Set<String>>(usedArtifacts);
            Set<Artifact> usedUndeclaredArtifacts = DefaultProjectDependencyAnalyzer.removeAll(usedUndeclaredArtifactsWithClasses.keySet(), declaredArtifacts);
            usedUndeclaredArtifactsWithClasses.keySet().retainAll(usedUndeclaredArtifacts);
            Set<Artifact> unusedDeclaredArtifacts = new LinkedHashSet<Artifact>(declaredArtifacts);
            unusedDeclaredArtifacts = DefaultProjectDependencyAnalyzer.removeAll(unusedDeclaredArtifacts, usedArtifacts.keySet());
            Set<Artifact> testArtifactsWithNonTestScope = DefaultProjectDependencyAnalyzer.getTestArtifactsWithNonTestScope(testOnlyArtifacts);
            return new ProjectDependencyAnalysis(usedDeclaredArtifacts, usedUndeclaredArtifactsWithClasses, unusedDeclaredArtifacts, testArtifactsWithNonTestScope);
        }
        catch (IOException exception) {
            throw new ProjectDependencyAnalyzerException("Cannot analyze dependencies", exception);
        }
    }

    private static Set<Artifact> removeAll(Set<Artifact> start, Set<Artifact> remove) {
        LinkedHashSet<Artifact> results = new LinkedHashSet<Artifact>(start.size());
        for (Artifact artifact : start) {
            boolean found = false;
            for (Artifact artifact2 : remove) {
                if (!artifact.getDependencyConflictId().equals(artifact2.getDependencyConflictId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            results.add(artifact);
        }
        return results;
    }

    private static Set<Artifact> getTestArtifactsWithNonTestScope(Set<Artifact> testOnlyArtifacts) {
        LinkedHashSet<Artifact> nonTestScopeArtifacts = new LinkedHashSet<Artifact>();
        for (Artifact artifact : testOnlyArtifacts) {
            if (!artifact.getScope().equals("compile")) continue;
            nonTestScopeArtifacts.add(artifact);
        }
        return nonTestScopeArtifacts;
    }

    private Map<Artifact, Set<String>> buildArtifactClassMap(MavenProject project, ClassesPatterns excludedClasses) throws IOException {
        LinkedHashMap<Artifact, Set<String>> artifactClassMap = new LinkedHashMap<Artifact, Set<String>>();
        Set dependencyArtifacts = project.getArtifacts();
        for (Artifact artifact : dependencyArtifacts) {
            File file = artifact.getFile();
            if (file != null && file.getName().endsWith(".jar")) {
                JarFile jarFile = new JarFile(file);
                try {
                    Enumeration<JarEntry> jarEntries = jarFile.entries();
                    HashSet<String> classes = new HashSet<String>();
                    while (jarEntries.hasMoreElements()) {
                        String entry = jarEntries.nextElement().getName();
                        if (!entry.endsWith(".class")) continue;
                        String className = entry.replace('/', '.');
                        if (excludedClasses.isMatch(className = className.substring(0, className.length() - ".class".length()))) continue;
                        classes.add(className);
                    }
                    artifactClassMap.put(artifact, classes);
                    continue;
                }
                finally {
                    jarFile.close();
                    continue;
                }
            }
            if (file == null || !file.isDirectory()) continue;
            URL url = file.toURI().toURL();
            Set<String> classes = this.classAnalyzer.analyze(url, excludedClasses);
            artifactClassMap.put(artifact, classes);
        }
        return artifactClassMap;
    }

    private static Set<String> buildTestOnlyDependencyClasses(Set<String> mainDependencyClasses, Set<String> testDependencyClasses) {
        HashSet<String> testOnlyDependencyClasses = new HashSet<String>(testDependencyClasses);
        testOnlyDependencyClasses.removeAll(mainDependencyClasses);
        return testOnlyDependencyClasses;
    }

    private Set<String> buildMainDependencyClasses(MavenProject project, ClassesPatterns excludedClasses) throws IOException {
        String outputDirectory = project.getBuild().getOutputDirectory();
        return this.buildDependencyClasses(outputDirectory, excludedClasses);
    }

    private Set<String> buildTestDependencyClasses(MavenProject project, ClassesPatterns excludedClasses) throws IOException {
        String testOutputDirectory = project.getBuild().getTestOutputDirectory();
        return this.buildDependencyClasses(testOutputDirectory, excludedClasses);
    }

    private Set<String> buildDependencyClasses(String path, ClassesPatterns excludedClasses) throws IOException {
        URL url = new File(path).toURI().toURL();
        return this.dependencyAnalyzer.analyze(url, excludedClasses);
    }

    private static Set<Artifact> buildDeclaredArtifacts(MavenProject project) {
        Set<Artifact> declaredArtifacts = project.getDependencyArtifacts();
        if (declaredArtifacts == null) {
            declaredArtifacts = Collections.emptySet();
        }
        return declaredArtifacts;
    }

    private static Map<Artifact, Set<String>> buildUsedArtifacts(Map<Artifact, Set<String>> artifactClassMap, Set<String> dependencyClasses) {
        HashMap<Artifact, Set<String>> usedArtifacts = new HashMap<Artifact, Set<String>>();
        for (String className : dependencyClasses) {
            Artifact artifact = DefaultProjectDependencyAnalyzer.findArtifactForClassName(artifactClassMap, className);
            if (artifact == null) continue;
            HashSet<String> classesFromArtifact = (HashSet<String>)usedArtifacts.get(artifact);
            if (classesFromArtifact == null) {
                classesFromArtifact = new HashSet<String>();
                usedArtifacts.put(artifact, classesFromArtifact);
            }
            classesFromArtifact.add(className);
        }
        return usedArtifacts;
    }

    private static Artifact findArtifactForClassName(Map<Artifact, Set<String>> artifactClassMap, String className) {
        for (Map.Entry<Artifact, Set<String>> entry : artifactClassMap.entrySet()) {
            if (!entry.getValue().contains(className)) continue;
            return entry.getKey();
        }
        return null;
    }
}

