/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.shared.dependency.analyzer.ClassFileVisitor;
import org.apache.maven.shared.dependency.analyzer.ClassesPatterns;

public class CollectorClassFileVisitor
implements ClassFileVisitor {
    private final Set<String> classes = new HashSet<String>();
    private final ClassesPatterns excludedClasses;

    public CollectorClassFileVisitor() {
        this(new ClassesPatterns());
    }

    public CollectorClassFileVisitor(ClassesPatterns excludedClasses) {
        this.excludedClasses = excludedClasses;
    }

    @Override
    public void visitClass(String className, InputStream in) {
        if (className.indexOf(36) < 0 && !this.excludedClasses.isMatch(className)) {
            this.classes.add(className);
        }
    }

    public Set<String> getClasses() {
        return this.classes;
    }
}

