/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.tag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.CustomizableSshSessionFactoryCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitTransportConfigCallback;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.apache.maven.scm.provider.git.jgit.command.PushException;
import org.apache.maven.scm.provider.git.jgit.command.ScmProviderAwareSshdSessionFactory;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.slf4j.Logger;

public class JGitTagCommand
extends AbstractTagCommand
implements GitCommand,
CustomizableSshSessionFactoryCommand {
    private BiFunction<GitScmProviderRepository, Logger, ScmProviderAwareSshdSessionFactory> sshSessionFactorySupplier = ScmProviderAwareSshdSessionFactory::new;

    @Override
    public void setSshSessionFactorySupplier(BiFunction<GitScmProviderRepository, Logger, ScmProviderAwareSshdSessionFactory> sshSessionFactorySupplier) {
        this.sshSessionFactorySupplier = sshSessionFactorySupplier;
    }

    public ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag, String message) throws ScmException {
        return this.executeTagCommand(repo, fileSet, tag, new ScmTagParameters(message));
    }

    public ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag, ScmTagParameters scmTagParameters) throws ScmException {
        if (tag == null || tag.trim().isEmpty()) {
            throw new ScmException("tag name must be specified");
        }
        if (!fileSet.getFileList().isEmpty()) {
            throw new ScmException("This provider doesn't support tagging subsets of a directory");
        }
        String escapedTagName = tag.trim().replace(' ', '_');
        Git git = null;
        try {
            git = JGitUtils.openRepo(fileSet.getBasedir());
            String tagMessage = scmTagParameters.getMessage();
            Ref tagRef = git.tag().setName(escapedTagName).setMessage(tagMessage).setForceUpdate(false).call();
            if (repo.isPushChanges()) {
                JGitTransportConfigCallback transportConfigCallback = new JGitTransportConfigCallback(this.sshSessionFactorySupplier.apply((GitScmProviderRepository)repo, this.logger));
                this.logger.info("push tag [" + escapedTagName + "] to remote...");
                JGitUtils.push(git, (GitScmProviderRepository)repo, new RefSpec("refs/tags/" + escapedTagName), EnumSet.of(RemoteRefUpdate.Status.OK, RemoteRefUpdate.Status.UP_TO_DATE), Optional.of(transportConfigCallback));
            }
            RevWalk revWalk = new RevWalk(git.getRepository());
            RevCommit commit = revWalk.parseCommit((AnyObjectId)tagRef.getObjectId());
            revWalk.close();
            TreeWalk walk = new TreeWalk(git.getRepository());
            walk.reset();
            walk.setRecursive(true);
            walk.addTree((AnyObjectId)commit.getTree());
            ArrayList<ScmFile> taggedFiles = new ArrayList<ScmFile>();
            while (walk.next()) {
                taggedFiles.add(new ScmFile(walk.getPathString(), ScmFileStatus.CHECKED_OUT));
            }
            walk.close();
            TagScmResult tagScmResult = new TagScmResult("JGit tag", taggedFiles);
            return tagScmResult;
        }
        catch (PushException e) {
            this.logger.debug("Failed to push tag", (Throwable)e);
            TagScmResult tagScmResult = new TagScmResult("JGit tag", "Failed to push tag: " + e.getMessage(), "", false);
            return tagScmResult;
        }
        catch (IOException | GitAPIException e) {
            throw new ScmException("JGit tag failure!", e);
        }
        finally {
            JGitUtils.closeRepo(git);
        }
    }
}

