/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.checkin;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.CustomizableSshSessionFactoryCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitTransportConfigCallback;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.apache.maven.scm.provider.git.jgit.command.PushException;
import org.apache.maven.scm.provider.git.jgit.command.ScmProviderAwareSshdSessionFactory;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.apache.maven.scm.provider.git.util.GitUtil;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.UserConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.slf4j.Logger;

public class JGitCheckInCommand
extends AbstractCheckInCommand
implements GitCommand,
CustomizableSshSessionFactoryCommand {
    protected static final String GIT_MAVEN_SECTION = "maven-scm";
    protected static final String GIT_MAILDOMAIN = "maildomain";
    protected static final String GIT_FORCE = "forceUsername";
    private BiFunction<GitScmProviderRepository, Logger, ScmProviderAwareSshdSessionFactory> sshSessionFactorySupplier = ScmProviderAwareSshdSessionFactory::new;

    @Override
    public void setSshSessionFactorySupplier(BiFunction<GitScmProviderRepository, Logger, ScmProviderAwareSshdSessionFactory> sshSessionFactorySupplier) {
        this.sshSessionFactorySupplier = sshSessionFactorySupplier;
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    public CheckInScmResult executeCommand(ScmProviderRepository repo, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        CheckInScmResult checkInScmResult;
        String message = parameters.getString(CommandParameter.MESSAGE);
        ScmVersion version = parameters.getScmVersion(CommandParameter.SCM_VERSION, null);
        Git git = null;
        try {
            Status status;
            File basedir = fileSet.getBasedir();
            git = JGitUtils.openRepo(basedir);
            boolean doCommit = false;
            if (!fileSet.getFileList().isEmpty()) {
                boolean bl = doCommit = JGitUtils.addAllFiles(git, fileSet).size() > 0;
                if (!doCommit) {
                    status = git.status().call();
                    doCommit = status.getAdded().size() > 0 || status.getChanged().size() > 0 || status.getRemoved().size() > 0;
                }
            } else {
                status = git.status().call();
                Set changeds = git.status().call().getModified();
                if (changeds.isEmpty()) {
                    if (!status.hasUncommittedChanges()) {
                        this.logger.warn("There are neither files to be added nor any uncommitted changes");
                        doCommit = false;
                    } else {
                        this.logger.debug("There are uncommitted changes in the git index");
                        doCommit = true;
                    }
                } else {
                    AddCommand add = git.add();
                    for (String changed : changeds) {
                        this.logger.debug("Add manually: {}", (Object)changed);
                        add.addFilepattern(changed);
                        doCommit = true;
                    }
                    add.call();
                }
            }
            List<Object> checkedInFiles = Collections.emptyList();
            if (doCommit) {
                UserInfo author = this.getAuthor(repo, git);
                UserInfo committer = this.getCommitter(repo, git);
                CommitCommand command = git.commit().setMessage(message).setAuthor(author.name, author.email).setCommitter(committer.name, committer.email);
                if (GitUtil.getSettings().isCommitNoVerify()) {
                    command.setNoVerify(true);
                }
                RevCommit commitRev = command.call();
                this.logger.debug("commit done: " + commitRev.getShortMessage());
                checkedInFiles = JGitUtils.getFilesInCommit(git.getRepository(), commitRev, fileSet.getBasedir());
                if (this.logger.isDebugEnabled()) {
                    for (ScmFile scmFile : checkedInFiles) {
                        this.logger.debug("in commit: " + scmFile);
                    }
                }
            } else {
                this.logger.info("nothing to commit");
            }
            if (repo.isPushChanges()) {
                String branch;
                String string = branch = version != null ? version.getName() : null;
                if (StringUtils.isBlank((CharSequence)branch)) {
                    branch = git.getRepository().getBranch();
                }
                RefSpec refSpec = new RefSpec("refs/heads/" + branch + ":" + "refs/heads/" + branch);
                this.logger.info("push changes to remote... " + refSpec);
                JGitTransportConfigCallback transportConfigCallback = new JGitTransportConfigCallback(this.sshSessionFactorySupplier.apply((GitScmProviderRepository)repo, this.logger));
                JGitUtils.push(git, (GitScmProviderRepository)repo, refSpec, EnumSet.of(RemoteRefUpdate.Status.OK, RemoteRefUpdate.Status.UP_TO_DATE), Optional.of(transportConfigCallback));
            }
            checkInScmResult = new CheckInScmResult("JGit checkin", checkedInFiles);
        }
        catch (PushException e) {
            this.logger.debug("Failed to push commits", (Throwable)e);
            CheckInScmResult checkInScmResult2 = new CheckInScmResult("JGit checkin", "Failed to push changes: " + e.getMessage(), "", false);
            JGitUtils.closeRepo(git);
            return checkInScmResult2;
        }
        catch (IOException | GitAPIException e2) {
            throw new ScmException("JGit checkin failure!", e2);
            {
                catch (Throwable throwable) {
                    JGitUtils.closeRepo(git);
                    throw throwable;
                }
            }
        }
        JGitUtils.closeRepo(git);
        return checkInScmResult;
    }

    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, ScmVersion version) throws ScmException {
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.MESSAGE, message);
        parameters.setScmVersion(CommandParameter.SCM_VERSION, version);
        return this.executeCommand(repo, fileSet, parameters);
    }

    private UserInfo getCommitter(ScmProviderRepository repo, Git git) {
        boolean forceMvnUser = git.getRepository().getConfig().getBoolean(GIT_MAVEN_SECTION, GIT_FORCE, false);
        UserConfig user = (UserConfig)git.getRepository().getConfig().get(UserConfig.KEY);
        String committerName = null;
        if (!forceMvnUser && !user.isCommitterNameImplicit()) {
            committerName = user.getCommitterName();
        }
        if (StringUtils.isBlank(committerName)) {
            committerName = repo.getUser();
        }
        if (StringUtils.isBlank(committerName)) {
            committerName = user.getCommitterName();
        }
        String committerMail = null;
        if (!user.isCommitterEmailImplicit()) {
            committerMail = user.getCommitterEmail();
        }
        if (StringUtils.isBlank(committerMail)) {
            String defaultDomain = git.getRepository().getConfig().getString(GIT_MAVEN_SECTION, null, GIT_MAILDOMAIN);
            defaultDomain = StringUtils.isNotBlank((CharSequence)defaultDomain) ? defaultDomain : this.getHostname();
            committerMail = StringUtils.isNotBlank((CharSequence)repo.getUser()) ? repo.getUser() + "@" + defaultDomain : user.getCommitterEmail();
        }
        return new UserInfo(committerName, committerMail);
    }

    private UserInfo getAuthor(ScmProviderRepository repo, Git git) {
        boolean forceMvnUser = git.getRepository().getConfig().getBoolean(GIT_MAVEN_SECTION, GIT_FORCE, false);
        UserConfig user = (UserConfig)git.getRepository().getConfig().get(UserConfig.KEY);
        String authorName = null;
        if (!forceMvnUser && !user.isAuthorNameImplicit()) {
            authorName = user.getAuthorName();
        }
        if (StringUtils.isBlank(authorName)) {
            authorName = repo.getUser();
        }
        if (StringUtils.isBlank(authorName)) {
            authorName = user.getAuthorName();
        }
        String authorMail = null;
        if (!user.isAuthorEmailImplicit()) {
            authorMail = user.getAuthorEmail();
        }
        if (StringUtils.isBlank(authorMail)) {
            String defaultDomain = git.getRepository().getConfig().getString(GIT_MAVEN_SECTION, null, GIT_MAILDOMAIN);
            defaultDomain = StringUtils.isNotBlank((CharSequence)defaultDomain) ? defaultDomain : this.getHostname();
            authorMail = StringUtils.isNotBlank((CharSequence)repo.getUser()) ? repo.getUser() + "@" + defaultDomain : user.getAuthorEmail();
        }
        return new UserInfo(authorName, authorMail);
    }

    private String getHostname() {
        String hostname;
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            hostname = localhost.getHostName();
        }
        catch (UnknownHostException e) {
            this.logger.warn("failed to resolve hostname to create mail address, defaulting to 'maven-scm-provider-jgit'");
            hostname = "maven-scm-provider-jgit";
        }
        return hostname;
    }

    private static final class UserInfo {
        final String name;
        final String email;

        UserInfo(String name, String email) {
            this.name = name;
            this.email = email;
        }
    }
}

