/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencyManagement;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.scope.ScopeManager;
import org.eclipse.aether.scope.SystemDependencyScope;

public abstract class AbstractDependencyManager
implements DependencyManager {
    protected final int depth;
    protected final int deriveUntil;
    protected final int applyFrom;
    protected final Map<Object, Holder<String>> managedVersions;
    protected final Map<Object, Holder<String>> managedScopes;
    protected final Map<Object, Holder<Boolean>> managedOptionals;
    protected final Map<Object, Holder<String>> managedLocalPaths;
    protected final Map<Object, Collection<Holder<Collection<Exclusion>>>> managedExclusions;
    protected final SystemDependencyScope systemDependencyScope;
    private final int hashCode;

    protected AbstractDependencyManager(int deriveUntil, int applyFrom, ScopeManager scopeManager) {
        this(0, deriveUntil, applyFrom, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), scopeManager != null ? (SystemDependencyScope)scopeManager.getSystemDependencyScope().orElse(null) : SystemDependencyScope.LEGACY);
    }

    protected AbstractDependencyManager(int depth, int deriveUntil, int applyFrom, Map<Object, Holder<String>> managedVersions, Map<Object, Holder<String>> managedScopes, Map<Object, Holder<Boolean>> managedOptionals, Map<Object, Holder<String>> managedLocalPaths, Map<Object, Collection<Holder<Collection<Exclusion>>>> managedExclusions, SystemDependencyScope systemDependencyScope) {
        this.depth = depth;
        this.deriveUntil = deriveUntil;
        this.applyFrom = applyFrom;
        this.managedVersions = Objects.requireNonNull(managedVersions);
        this.managedScopes = Objects.requireNonNull(managedScopes);
        this.managedOptionals = Objects.requireNonNull(managedOptionals);
        this.managedLocalPaths = Objects.requireNonNull(managedLocalPaths);
        this.managedExclusions = Objects.requireNonNull(managedExclusions);
        this.systemDependencyScope = systemDependencyScope;
        this.hashCode = Objects.hash(depth, deriveUntil, applyFrom, managedVersions, managedScopes, managedOptionals, managedLocalPaths, managedExclusions);
    }

    protected abstract DependencyManager newInstance(Map<Object, Holder<String>> var1, Map<Object, Holder<String>> var2, Map<Object, Holder<Boolean>> var3, Map<Object, Holder<String>> var4, Map<Object, Collection<Holder<Collection<Exclusion>>>> var5);

    public DependencyManager deriveChildManager(DependencyCollectionContext context) {
        Objects.requireNonNull(context, "context cannot be null");
        if (!this.isDerived()) {
            return this;
        }
        Map<Object, Holder<String>> managedVersions = this.managedVersions;
        Map<Object, Holder<String>> managedScopes = this.managedScopes;
        Map<Object, Holder<Boolean>> managedOptionals = this.managedOptionals;
        Map<Object, Holder<String>> managedLocalPaths = this.managedLocalPaths;
        Map<Object, Collection<Holder<Collection<Exclusion>>>> managedExclusions = this.managedExclusions;
        for (Dependency managedDependency : context.getManagedDependencies()) {
            Collection exclusions;
            String localPath;
            Boolean optional;
            String scope;
            Artifact artifact = managedDependency.getArtifact();
            Key key = new Key(artifact);
            String version = artifact.getVersion();
            if (!version.isEmpty() && !managedVersions.containsKey(key)) {
                if (managedVersions == this.managedVersions) {
                    managedVersions = new HashMap<Object, Holder<String>>(this.managedVersions);
                }
                managedVersions.put(key, new Holder<String>(this.depth, version));
            }
            if (!(scope = managedDependency.getScope()).isEmpty() && !managedScopes.containsKey(key)) {
                if (managedScopes == this.managedScopes) {
                    managedScopes = new HashMap<Object, Holder<String>>(this.managedScopes);
                }
                managedScopes.put(key, new Holder<String>(this.depth, scope));
            }
            if ((optional = managedDependency.getOptional()) != null && !managedOptionals.containsKey(key)) {
                if (managedOptionals == this.managedOptionals) {
                    managedOptionals = new HashMap<Object, Holder<Boolean>>(this.managedOptionals);
                }
                managedOptionals.put(key, new Holder<Boolean>(this.depth, optional));
            }
            String string = localPath = this.systemDependencyScope == null ? null : this.systemDependencyScope.getSystemPath(managedDependency.getArtifact());
            if (localPath != null && !managedLocalPaths.containsKey(key)) {
                if (managedLocalPaths == this.managedLocalPaths) {
                    managedLocalPaths = new HashMap<Object, Holder<String>>(this.managedLocalPaths);
                }
                managedLocalPaths.put(key, new Holder<String>(this.depth, localPath));
            }
            if ((exclusions = managedDependency.getExclusions()).isEmpty()) continue;
            if (managedExclusions == this.managedExclusions) {
                managedExclusions = new HashMap<Object, Collection<Holder<Collection<Exclusion>>>>(this.managedExclusions);
            }
            Collection managed = managedExclusions.computeIfAbsent(key, k -> new ArrayList());
            managed.add(new Holder<Collection>(this.depth, exclusions));
        }
        return this.newInstance(managedVersions, managedScopes, managedOptionals, managedLocalPaths, managedExclusions);
    }

    public DependencyManagement manageDependency(Dependency dependency) {
        Collection<Holder<Collection<Exclusion>>> exclusions;
        Objects.requireNonNull(dependency, "dependency cannot be null");
        DependencyManagement management = null;
        Key key = new Key(dependency.getArtifact());
        if (this.isApplied()) {
            Holder<Boolean> optional;
            Holder<String> localPath;
            Holder<String> scope;
            Holder<String> version = this.managedVersions.get(key);
            if (version != null && this.isApplicable(version)) {
                management = new DependencyManagement();
                management.setVersion(version.getValue());
            }
            if ((scope = this.managedScopes.get(key)) != null && this.isApplicable(scope)) {
                if (management == null) {
                    management = new DependencyManagement();
                }
                management.setScope(scope.getValue());
                if (this.systemDependencyScope != null && !this.systemDependencyScope.is(scope.getValue()) && this.systemDependencyScope.getSystemPath(dependency.getArtifact()) != null) {
                    HashMap properties = new HashMap(dependency.getArtifact().getProperties());
                    this.systemDependencyScope.setSystemPath(properties, null);
                    management.setProperties(properties);
                }
            }
            if (this.systemDependencyScope != null && (scope != null && this.systemDependencyScope.is(scope.getValue()) || scope == null && this.systemDependencyScope.is(dependency.getScope())) && (localPath = this.managedLocalPaths.get(key)) != null) {
                if (management == null) {
                    management = new DependencyManagement();
                }
                HashMap properties = new HashMap(dependency.getArtifact().getProperties());
                this.systemDependencyScope.setSystemPath(properties, localPath.getValue());
                management.setProperties(properties);
            }
            if ((optional = this.managedOptionals.get(key)) != null && this.isApplicable(optional)) {
                if (management == null) {
                    management = new DependencyManagement();
                }
                management.setOptional(optional.getValue());
            }
        }
        if ((exclusions = this.managedExclusions.get(key)) != null) {
            if (management == null) {
                management = new DependencyManagement();
            }
            LinkedHashSet<Exclusion> result = new LinkedHashSet<Exclusion>(dependency.getExclusions());
            for (Holder<Collection<Exclusion>> exclusion : exclusions) {
                result.addAll(exclusion.getValue());
            }
            management.setExclusions(result);
        }
        return management;
    }

    protected boolean isDerived() {
        return this.depth < this.deriveUntil;
    }

    protected boolean isApplied() {
        return this.depth >= this.applyFrom;
    }

    protected boolean isApplicable(Holder<?> holder) {
        return holder.getDepth() == 0 || this.depth > holder.getDepth() + 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AbstractDependencyManager that = (AbstractDependencyManager)obj;
        return this.depth == that.depth && this.deriveUntil == that.deriveUntil && this.applyFrom == that.applyFrom && this.managedVersions.equals(that.managedVersions) && this.managedScopes.equals(that.managedScopes) && this.managedOptionals.equals(that.managedOptionals) && this.managedExclusions.equals(that.managedExclusions);
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected static class Key {
        private final Artifact artifact;
        private final int hashCode;

        Key(Artifact artifact) {
            this.artifact = artifact;
            this.hashCode = Objects.hash(artifact.getGroupId(), artifact.getArtifactId());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key that = (Key)obj;
            return this.artifact.getArtifactId().equals(that.artifact.getArtifactId()) && this.artifact.getGroupId().equals(that.artifact.getGroupId()) && this.artifact.getExtension().equals(that.artifact.getExtension()) && this.artifact.getClassifier().equals(that.artifact.getClassifier());
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return String.valueOf(this.artifact);
        }
    }

    protected static class Holder<T> {
        private final int depth;
        private final T value;

        Holder(int depth, T value) {
            this.depth = depth;
            this.value = Objects.requireNonNull(value);
        }

        public int getDepth() {
            return this.depth;
        }

        public T getValue() {
            return this.value;
        }
    }
}

