/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.transformer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.graph.transformer.ConflictIdSorter;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.TransformationContextKeys;

public final class ClassicConflictResolver
extends ConflictResolver {
    private final ConflictResolver.VersionSelector versionSelector;
    private final ConflictResolver.ScopeSelector scopeSelector;
    private final ConflictResolver.ScopeDeriver scopeDeriver;
    private final ConflictResolver.OptionalitySelector optionalitySelector;

    public ClassicConflictResolver(ConflictResolver.VersionSelector versionSelector, ConflictResolver.ScopeSelector scopeSelector, ConflictResolver.OptionalitySelector optionalitySelector, ConflictResolver.ScopeDeriver scopeDeriver) {
        this.versionSelector = Objects.requireNonNull(versionSelector, "version selector cannot be null");
        this.scopeSelector = Objects.requireNonNull(scopeSelector, "scope selector cannot be null");
        this.optionalitySelector = Objects.requireNonNull(optionalitySelector, "optionality selector cannot be null");
        this.scopeDeriver = Objects.requireNonNull(scopeDeriver, "scope deriver cannot be null");
    }

    @Override
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        Objects.requireNonNull(node, "node cannot be null");
        Objects.requireNonNull(context, "context cannot be null");
        List sortedConflictIds = (List)context.get(TransformationContextKeys.SORTED_CONFLICT_IDS);
        if (sortedConflictIds == null) {
            ConflictIdSorter sorter = new ConflictIdSorter();
            sorter.transformGraph(node, context);
            sortedConflictIds = (List)context.get(TransformationContextKeys.SORTED_CONFLICT_IDS);
        }
        Map stats = (Map)context.get(TransformationContextKeys.STATS);
        long time1 = System.nanoTime();
        Collection conflictIdCycles = (Collection)context.get(TransformationContextKeys.CYCLIC_CONFLICT_IDS);
        if (conflictIdCycles == null) {
            throw new RepositoryException("conflict id cycles have not been identified");
        }
        Map conflictIds = (Map)context.get(TransformationContextKeys.CONFLICT_IDS);
        if (conflictIds == null) {
            throw new RepositoryException("conflict groups have not been identified");
        }
        HashMap<String, Collection> cyclicPredecessors = new HashMap<String, Collection>();
        for (Collection cycle : conflictIdCycles) {
            for (String conflictId : cycle) {
                Collection predecessors = cyclicPredecessors.computeIfAbsent(conflictId, k -> new HashSet());
                predecessors.addAll(cycle);
            }
        }
        State state = new State(node, conflictIds, sortedConflictIds.size(), context);
        Iterator it = sortedConflictIds.iterator();
        while (it.hasNext()) {
            String conflictId = (String)it.next();
            state.prepare(conflictId, (Collection)cyclicPredecessors.get(conflictId));
            this.gatherConflictItems(node, state);
            state.finish();
            if (!state.items.isEmpty()) {
                ConflictContext ctx = state.conflictCtx;
                state.versionSelector.selectVersion(ctx);
                if (ctx.winner == null) {
                    throw new RepositoryException("conflict resolver did not select winner among " + state.items);
                }
                DependencyNode winner = ((ConflictItem)ctx.winner).node;
                state.scopeSelector.selectScope(ctx);
                if (ConflictResolver.Verbosity.NONE != state.verbosity) {
                    winner.setData((Object)"conflict.originalScope", (Object)winner.getDependency().getScope());
                }
                winner.setScope(ctx.scope);
                state.optionalitySelector.selectOptionality(ctx);
                if (ConflictResolver.Verbosity.NONE != state.verbosity) {
                    winner.setData((Object)"conflict.originalOptionality", (Object)winner.getDependency().isOptional());
                }
                winner.setOptional(ctx.optional);
                ClassicConflictResolver.removeLosers(state);
            }
            state.winner();
            if (it.hasNext() || conflictIdCycles.isEmpty() || state.conflictCtx.winner == null) continue;
            DependencyNode winner = ((ConflictItem)state.conflictCtx.winner).node;
            state.prepare("", null);
            this.gatherConflictItems(winner, state);
        }
        if (stats != null) {
            long time2 = System.nanoTime();
            stats.put("ConflictResolver.totalTime", time2 - time1);
            stats.put("ConflictResolver.conflictItemCount", state.totalConflictItems);
        }
        return node;
    }

    private boolean gatherConflictItems(DependencyNode node, State state) throws RepositoryException {
        String conflictId = state.conflictIds.get(node);
        if (state.currentId.equals(conflictId)) {
            state.add(node);
        } else {
            if (state.loser(node, conflictId)) {
                return false;
            }
            if (state.push(node, conflictId)) {
                Iterator it = node.getChildren().iterator();
                while (it.hasNext()) {
                    DependencyNode child = (DependencyNode)it.next();
                    if (this.gatherConflictItems(child, state)) continue;
                    it.remove();
                }
                state.pop();
            }
        }
        return true;
    }

    private static void removeLosers(State state) {
        String childArtifactId;
        DependencyNode child;
        ConflictItem winner = (ConflictItem)state.conflictCtx.winner;
        String winnerArtifactId = ArtifactIdUtils.toId(winner.node.getArtifact());
        List<DependencyNode> previousParent = null;
        ListIterator<DependencyNode> childIt = null;
        HashSet<String> toRemoveIds = new HashSet<String>();
        block0: for (ConflictItem item : state.items) {
            if (item == winner) continue;
            if (item.parent != previousParent) {
                childIt = item.parent.listIterator();
                previousParent = item.parent;
            }
            while (childIt.hasNext()) {
                child = childIt.next();
                if (child != item.node) continue;
                if (ConflictResolver.Verbosity.NONE == state.verbosity) {
                    childIt.remove();
                    continue block0;
                }
                if (ConflictResolver.Verbosity.STANDARD == state.verbosity && !Objects.equals(winnerArtifactId, childArtifactId = ArtifactIdUtils.toId(child.getArtifact()))) {
                    toRemoveIds.add(childArtifactId);
                }
                DefaultDependencyNode loser = new DefaultDependencyNode(child);
                loser.setData((Object)"conflict.winner", (Object)winner.node);
                loser.setData((Object)"conflict.originalScope", (Object)loser.getDependency().getScope());
                loser.setData((Object)"conflict.originalOptionality", (Object)loser.getDependency().isOptional());
                loser.setScope(item.getScopes().iterator().next());
                loser.setChildren(Collections.emptyList());
                childIt.set((DependencyNode)loser);
                item.node = loser;
                continue block0;
            }
        }
        if (ConflictResolver.Verbosity.STANDARD == state.verbosity && !toRemoveIds.isEmpty()) {
            previousParent = null;
            block2: for (ConflictItem item : state.items) {
                if (item == winner) continue;
                if (item.parent != previousParent) {
                    childIt = item.parent.listIterator();
                    previousParent = item.parent;
                }
                while (childIt.hasNext()) {
                    child = childIt.next();
                    if (child != item.node) continue;
                    childArtifactId = ArtifactIdUtils.toId(child.getArtifact());
                    if (!toRemoveIds.contains(childArtifactId) || ClassicConflictResolver.relatedSiblingsCount(child.getArtifact(), item.parent) <= 1L) continue block2;
                    childIt.remove();
                    continue block2;
                }
            }
        }
    }

    private static long relatedSiblingsCount(Artifact artifact, List<DependencyNode> parent) {
        String ga = artifact.getGroupId() + ":" + artifact.getArtifactId();
        return parent.stream().map(DependencyNode::getArtifact).filter(a -> ga.equals(a.getGroupId() + ":" + a.getArtifactId())).count();
    }

    final class State {
        String currentId;
        int totalConflictItems;
        final ConflictResolver.Verbosity verbosity;
        final Map<String, DependencyNode> resolvedIds;
        final Collection<String> potentialAncestorIds;
        final Map<DependencyNode, String> conflictIds;
        final List<ConflictItem> items;
        final Map<List<DependencyNode>, NodeInfo> infos;
        final Map<List<DependencyNode>, Boolean> stack;
        final List<DependencyNode> parentNodes;
        final List<String> parentScopes;
        final List<Boolean> parentOptionals;
        final List<NodeInfo> parentInfos;
        final ConflictContext conflictCtx;
        final ScopeContext scopeCtx;
        final ConflictResolver.VersionSelector versionSelector;
        final ConflictResolver.ScopeSelector scopeSelector;
        final ConflictResolver.ScopeDeriver scopeDeriver;
        final ConflictResolver.OptionalitySelector optionalitySelector;

        State(DependencyNode root, Map<DependencyNode, String> conflictIds, int conflictIdCount, DependencyGraphTransformationContext context) throws RepositoryException {
            this.conflictIds = conflictIds;
            this.verbosity = ConflictResolver.getVerbosity(context.getSession());
            this.potentialAncestorIds = new HashSet<String>(conflictIdCount * 2);
            this.resolvedIds = new HashMap<String, DependencyNode>(conflictIdCount * 2);
            this.items = new ArrayList<ConflictItem>(256);
            this.infos = new IdentityHashMap<List<DependencyNode>, NodeInfo>(64);
            this.stack = new IdentityHashMap<List<DependencyNode>, Boolean>(64);
            this.parentNodes = new ArrayList<DependencyNode>(64);
            this.parentScopes = new ArrayList<String>(64);
            this.parentOptionals = new ArrayList<Boolean>(64);
            this.parentInfos = new ArrayList<NodeInfo>(64);
            this.conflictCtx = new ConflictContext(root, conflictIds, this.items);
            this.scopeCtx = new ScopeContext(null, null);
            this.versionSelector = ClassicConflictResolver.this.versionSelector.getInstance(root, context);
            this.scopeSelector = ClassicConflictResolver.this.scopeSelector.getInstance(root, context);
            this.scopeDeriver = ClassicConflictResolver.this.scopeDeriver.getInstance(root, context);
            this.optionalitySelector = ClassicConflictResolver.this.optionalitySelector.getInstance(root, context);
        }

        void prepare(String conflictId, Collection<String> cyclicPredecessors) {
            this.currentId = conflictId;
            this.conflictCtx.conflictId = conflictId;
            this.conflictCtx.winner = null;
            this.conflictCtx.scope = null;
            this.conflictCtx.optional = null;
            this.items.clear();
            this.infos.clear();
            if (cyclicPredecessors != null) {
                this.potentialAncestorIds.addAll(cyclicPredecessors);
            }
        }

        void finish() {
            List<DependencyNode> previousParent = null;
            int previousDepth = 0;
            this.totalConflictItems += this.items.size();
            ListIterator<ConflictItem> iterator = this.items.listIterator(this.items.size());
            while (iterator.hasPrevious()) {
                ConflictItem item = iterator.previous();
                if (item.parent == previousParent) {
                    item.depth = previousDepth;
                    continue;
                }
                if (item.parent == null) continue;
                previousParent = item.parent;
                NodeInfo info = this.infos.get(previousParent);
                item.depth = previousDepth = info.minDepth + 1;
            }
            this.potentialAncestorIds.add(this.currentId);
        }

        void winner() {
            this.resolvedIds.put(this.currentId, this.conflictCtx.winner != null ? ((ConflictItem)this.conflictCtx.winner).node : null);
        }

        boolean loser(DependencyNode node, String conflictId) {
            DependencyNode winner = this.resolvedIds.get(conflictId);
            return winner != null && winner != node;
        }

        boolean push(DependencyNode node, String conflictId) throws RepositoryException {
            List graphNode;
            if (conflictId == null) {
                if (node.getDependency() != null) {
                    if (node.getData().get("conflict.winner") != null) {
                        return false;
                    }
                    throw new RepositoryException("missing conflict id for node " + node);
                }
            } else if (!this.potentialAncestorIds.contains(conflictId)) {
                return false;
            }
            if (this.stack.put(graphNode = node.getChildren(), Boolean.TRUE) != null) {
                return false;
            }
            int depth = this.depth();
            String scope = this.deriveScope(node, conflictId);
            boolean optional = this.deriveOptional(node, conflictId);
            NodeInfo info = this.infos.get(graphNode);
            if (info == null) {
                info = new NodeInfo(depth, scope, optional);
                this.infos.put(graphNode, info);
                this.parentInfos.add(info);
                this.parentNodes.add(node);
                this.parentScopes.add(scope);
                this.parentOptionals.add(optional);
            } else {
                int changes = info.update(depth, scope, optional);
                if (changes == 0) {
                    this.stack.remove(graphNode);
                    return false;
                }
                this.parentInfos.add(null);
                this.parentNodes.add(node);
                this.parentScopes.add(scope);
                this.parentOptionals.add(optional);
                if (info.children != null) {
                    ConflictItem item;
                    ListIterator<ConflictItem> itemIterator;
                    if ((changes & 1) != 0) {
                        itemIterator = info.children.listIterator(info.children.size());
                        while (itemIterator.hasPrevious()) {
                            item = itemIterator.previous();
                            String childScope = this.deriveScope(item.node, null);
                            item.addScope(childScope);
                        }
                    }
                    if ((changes & 2) != 0) {
                        itemIterator = info.children.listIterator(info.children.size());
                        while (itemIterator.hasPrevious()) {
                            item = itemIterator.previous();
                            boolean childOptional = this.deriveOptional(item.node, null);
                            item.addOptional(childOptional);
                        }
                    }
                }
            }
            return true;
        }

        void pop() {
            int last = this.parentInfos.size() - 1;
            this.parentInfos.remove(last);
            this.parentScopes.remove(last);
            this.parentOptionals.remove(last);
            DependencyNode node = this.parentNodes.remove(last);
            this.stack.remove(node.getChildren());
        }

        void add(DependencyNode node) throws RepositoryException {
            DependencyNode parent = this.parent();
            if (parent == null) {
                ConflictItem item = this.newConflictItem(parent, node);
                this.items.add(item);
            } else {
                NodeInfo info = this.parentInfos.get(this.parentInfos.size() - 1);
                if (info != null) {
                    ConflictItem item = this.newConflictItem(parent, node);
                    info.add(item);
                    this.items.add(item);
                }
            }
        }

        private ConflictItem newConflictItem(DependencyNode parent, DependencyNode node) throws RepositoryException {
            return new ConflictItem(parent, node, this.deriveScope(node, null), this.deriveOptional(node, null));
        }

        private int depth() {
            return this.parentNodes.size();
        }

        private DependencyNode parent() {
            int size = this.parentNodes.size();
            return size <= 0 ? null : this.parentNodes.get(size - 1);
        }

        private String deriveScope(DependencyNode node, String conflictId) throws RepositoryException {
            if ((node.getManagedBits() & 2) != 0 || conflictId != null && this.resolvedIds.containsKey(conflictId)) {
                return this.scope(node.getDependency());
            }
            int depth = this.parentNodes.size();
            this.scopes(depth, node.getDependency());
            if (depth > 0) {
                this.scopeDeriver.deriveScope(this.scopeCtx);
            }
            return this.scopeCtx.derivedScope;
        }

        private void scopes(int parent, Dependency child) {
            this.scopeCtx.parentScope = parent > 0 ? this.parentScopes.get(parent - 1) : null;
            this.scopeCtx.derivedScope = this.scope(child);
            this.scopeCtx.childScope = this.scope(child);
        }

        private String scope(Dependency dependency) {
            return dependency != null ? dependency.getScope() : null;
        }

        private boolean deriveOptional(DependencyNode node, String conflictId) {
            boolean optional;
            Dependency dep = node.getDependency();
            boolean bl = optional = dep != null && dep.isOptional();
            if (optional || (node.getManagedBits() & 4) != 0 || conflictId != null && this.resolvedIds.containsKey(conflictId)) {
                return optional;
            }
            int depth = this.parentNodes.size();
            return depth > 0 ? this.parentOptionals.get(depth - 1) : false;
        }
    }

    private static final class ConflictContext
    extends ConflictResolver.ConflictContext {
        final DependencyNode root;
        final Map<DependencyNode, String> conflictIds;
        final Collection<ConflictResolver.ConflictItem> items;
        String conflictId;
        ConflictResolver.ConflictItem winner;
        String scope;
        Boolean optional;

        private ConflictContext(DependencyNode root, Map<DependencyNode, String> conflictIds, Collection<ConflictItem> items) {
            this.root = root;
            this.conflictIds = conflictIds;
            this.items = Collections.unmodifiableCollection(items);
        }

        @Override
        public DependencyNode getRoot() {
            return this.root;
        }

        @Override
        public boolean isIncluded(DependencyNode node) {
            return this.conflictId.equals(this.conflictIds.get(node));
        }

        @Override
        public Collection<ConflictResolver.ConflictItem> getItems() {
            return this.items;
        }

        @Override
        public ConflictResolver.ConflictItem getWinner() {
            return this.winner;
        }

        @Override
        public void setWinner(ConflictResolver.ConflictItem winner) {
            this.winner = winner;
        }

        @Override
        public String getScope() {
            return this.scope;
        }

        @Override
        public void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public Boolean getOptional() {
            return this.optional;
        }

        @Override
        public void setOptional(Boolean optional) {
            this.optional = optional;
        }

        public String toString() {
            return this.winner + " @ " + this.scope + " < " + this.items;
        }
    }

    private static final class ConflictItem
    extends ConflictResolver.ConflictItem {
        final List<DependencyNode> parent;
        final Artifact artifact;
        DependencyNode node;
        int depth;
        Object scopes;
        int optionalities;
        public static final int OPTIONAL_FALSE = 1;
        public static final int OPTIONAL_TRUE = 2;

        private ConflictItem(DependencyNode parent, DependencyNode node, String scope, boolean optional) {
            if (parent != null) {
                this.parent = parent.getChildren();
                this.artifact = parent.getArtifact();
            } else {
                this.parent = null;
                this.artifact = null;
            }
            this.node = node;
            this.scopes = scope;
            this.optionalities = optional ? 2 : 1;
        }

        @Override
        public boolean isSibling(ConflictResolver.ConflictItem item) {
            return this.parent == ((ConflictItem)item).parent;
        }

        @Override
        public DependencyNode getNode() {
            return this.node;
        }

        @Override
        public Dependency getDependency() {
            return this.node.getDependency();
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public Collection<String> getScopes() {
            if (this.scopes instanceof String) {
                return Collections.singleton((String)this.scopes);
            }
            return (Collection)this.scopes;
        }

        void addScope(String scope) {
            if (this.scopes instanceof Collection) {
                ((Collection)this.scopes).add(scope);
            } else if (!this.scopes.equals(scope)) {
                HashSet<String> set = new HashSet<String>();
                set.add((String)this.scopes);
                set.add(scope);
                this.scopes = set;
            }
        }

        @Override
        public int getOptionalities() {
            return this.optionalities;
        }

        void addOptional(boolean optional) {
            this.optionalities |= optional ? 2 : 1;
        }

        public String toString() {
            return this.node + " @ " + this.depth + " < " + this.artifact;
        }
    }

    private static final class ScopeContext
    extends ConflictResolver.ScopeContext {
        private String parentScope;
        private String childScope;
        private String derivedScope;

        private ScopeContext(String parentScope, String childScope) {
            this.parentScope = parentScope != null ? parentScope : "";
            this.derivedScope = childScope != null ? childScope : "";
            this.childScope = childScope != null ? childScope : "";
        }

        @Override
        public String getParentScope() {
            return this.parentScope;
        }

        @Override
        public String getChildScope() {
            return this.childScope;
        }

        @Override
        public String getDerivedScope() {
            return this.derivedScope;
        }

        @Override
        public void setDerivedScope(String derivedScope) {
            this.derivedScope = derivedScope != null ? derivedScope : "";
        }
    }

    static final class NodeInfo {
        int minDepth;
        Object derivedScopes;
        int derivedOptionalities;
        List<ConflictItem> children;
        static final int CHANGE_SCOPE = 1;
        static final int CHANGE_OPTIONAL = 2;
        private static final int OPT_FALSE = 1;
        private static final int OPT_TRUE = 2;

        NodeInfo(int depth, String derivedScope, boolean optional) {
            this.minDepth = depth;
            this.derivedScopes = derivedScope;
            this.derivedOptionalities = optional ? 2 : 1;
        }

        int update(int depth, String derivedScope, boolean optional) {
            int bit;
            int changes;
            if (depth < this.minDepth) {
                this.minDepth = depth;
            }
            if (this.derivedScopes.equals(derivedScope)) {
                changes = 0;
            } else if (this.derivedScopes instanceof Collection) {
                changes = ((Collection)this.derivedScopes).add(derivedScope) ? 1 : 0;
            } else {
                HashSet<String> scopes = new HashSet<String>();
                scopes.add((String)this.derivedScopes);
                scopes.add(derivedScope);
                this.derivedScopes = scopes;
                changes = 1;
            }
            int n = bit = optional ? 2 : 1;
            if ((this.derivedOptionalities & bit) == 0) {
                this.derivedOptionalities |= bit;
                changes |= 2;
            }
            return changes;
        }

        void add(ConflictItem item) {
            if (this.children == null) {
                this.children = new ArrayList<ConflictItem>(1);
            }
            this.children.add(item);
        }
    }
}

