/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.StringDigestUtil;

public final class RepositoryIdHelper {
    private static final Map<String, String> ILLEGAL_REPO_ID_REPLACEMENTS;
    private static final String CENTRAL_REPOSITORY_ID = "central";
    private static final Collection<String> CENTRAL_URLS;
    private static final Predicate<RemoteRepository> CENTRAL_DIRECT_ONLY;

    private RepositoryIdHelper() {
    }

    public static String remoteRepositoryUniqueId(RemoteRepository repository) {
        if (CENTRAL_DIRECT_ONLY.test(repository)) {
            return CENTRAL_REPOSITORY_ID;
        }
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(repository.getId());
        buffer.append(" (").append(repository.getUrl());
        buffer.append(", ").append(repository.getContentType());
        boolean r = repository.getPolicy(false).isEnabled();
        boolean s = repository.getPolicy(true).isEnabled();
        if (r && s) {
            buffer.append(", releases+snapshots");
        } else if (r) {
            buffer.append(", releases");
        } else if (s) {
            buffer.append(", snapshots");
        } else {
            buffer.append(", disabled");
        }
        if (repository.isRepositoryManager()) {
            buffer.append(", managed(");
            for (RemoteRepository mirroredRepo : repository.getMirroredRepositories()) {
                buffer.append(RepositoryIdHelper.remoteRepositoryUniqueId(mirroredRepo));
            }
            buffer.append(")");
        }
        if (repository.isBlocked()) {
            buffer.append(", blocked");
        }
        buffer.append(")");
        return RepositoryIdHelper.idToPathSegment((ArtifactRepository)repository) + "-" + StringDigestUtil.sha1(buffer.toString());
    }

    public static Function<ArtifactRepository, String> cachedIdToPathSegment(RepositorySystemSession session) {
        Objects.requireNonNull(session, "session");
        return (Function)session.getData().computeIfAbsent((Object)(RepositoryIdHelper.class.getSimpleName() + "-idToPathSegmentFunction"), () -> RepositoryIdHelper.cachedIdToPathSegmentFunction(session));
    }

    private static Function<ArtifactRepository, String> cachedIdToPathSegmentFunction(RepositorySystemSession session) {
        if (session.getCache() != null) {
            return repository -> ((ConcurrentHashMap)session.getCache().computeIfAbsent(session, (Object)(RepositoryIdHelper.class.getSimpleName() + "-idToPathSegmentCache"), ConcurrentHashMap::new)).computeIfAbsent(repository.getId(), id -> RepositoryIdHelper.idToPathSegment(repository));
        }
        return RepositoryIdHelper::idToPathSegment;
    }

    static String idToPathSegment(ArtifactRepository repository) {
        if (repository instanceof RemoteRepository) {
            StringBuilder result = new StringBuilder(repository.getId());
            for (Map.Entry<String, String> entry : ILLEGAL_REPO_ID_REPLACEMENTS.entrySet()) {
                String illegal = entry.getKey();
                int pos = result.indexOf(illegal);
                while (pos >= 0) {
                    result.replace(pos, pos + illegal.length(), entry.getValue());
                    pos = result.indexOf(illegal);
                }
            }
            return result.toString();
        }
        return repository.getId();
    }

    static {
        HashMap<String, String> illegalRepoIdReplacements = new HashMap<String, String>();
        illegalRepoIdReplacements.put("\\", "-BACKSLASH-");
        illegalRepoIdReplacements.put("/", "-SLASH-");
        illegalRepoIdReplacements.put(":", "-COLON-");
        illegalRepoIdReplacements.put("\"", "-QUOTE-");
        illegalRepoIdReplacements.put("<", "-LT-");
        illegalRepoIdReplacements.put(">", "-GT-");
        illegalRepoIdReplacements.put("|", "-PIPE-");
        illegalRepoIdReplacements.put("?", "-QMARK-");
        illegalRepoIdReplacements.put("*", "-ASTERISK-");
        ILLEGAL_REPO_ID_REPLACEMENTS = Collections.unmodifiableMap(illegalRepoIdReplacements);
        CENTRAL_URLS = Collections.unmodifiableList(Arrays.asList("https://repo.maven.apache.org/maven2", "https://repo1.maven.org/maven2", "https://maven-central.storage-download.googleapis.com/maven2"));
        CENTRAL_DIRECT_ONLY = remoteRepository -> CENTRAL_REPOSITORY_ID.equals(remoteRepository.getId()) && "https".equals(remoteRepository.getProtocol().toLowerCase(Locale.ENGLISH)) && CENTRAL_URLS.stream().anyMatch(remoteUrl -> {
            String rurl = remoteRepository.getUrl().toLowerCase(Locale.ENGLISH);
            if (rurl.endsWith("/")) {
                rurl = rurl.substring(0, rurl.length() - 1);
            }
            return rurl.equals(remoteUrl);
        }) && remoteRepository.getPolicy(false).isEnabled() && !remoteRepository.getPolicy(true).isEnabled() && remoteRepository.getMirroredRepositories().isEmpty() && !remoteRepository.isRepositoryManager() && !remoteRepository.isBlocked();
    }
}

