/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util;

import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.aether.internal.test.util.TestVersion;
import org.eclipse.aether.internal.test.util.TestVersionConstraint;
import org.eclipse.aether.internal.test.util.TestVersionRange;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.eclipse.aether.version.VersionRange;
import org.eclipse.aether.version.VersionScheme;

final class TestVersionScheme
implements VersionScheme {
    TestVersionScheme() {
    }

    public Version parseVersion(String version) {
        Objects.requireNonNull(version, "version cannot be null");
        return new TestVersion(version);
    }

    public VersionRange parseVersionRange(String range) throws InvalidVersionSpecificationException {
        Objects.requireNonNull(range, "range cannot be null");
        return new TestVersionRange(range);
    }

    public VersionConstraint parseVersionConstraint(String constraint) throws InvalidVersionSpecificationException {
        Objects.requireNonNull(constraint, "constraint cannot be null");
        ArrayList<VersionRange> ranges = new ArrayList<VersionRange>();
        String process = constraint;
        while (process.startsWith("[") || process.startsWith("(")) {
            int index2;
            int index1 = process.indexOf(41);
            int index = index2 = process.indexOf(93);
            if (index2 < 0 || index1 >= 0 && index1 < index2) {
                index = index1;
            }
            if (index < 0) {
                throw new InvalidVersionSpecificationException(constraint, "Unbounded version range " + constraint);
            }
            VersionRange range = this.parseVersionRange(process.substring(0, index + 1));
            ranges.add(range);
            if (!(process = process.substring(index + 1).trim()).startsWith(",")) continue;
            process = process.substring(1).trim();
        }
        if (!process.isEmpty() && !ranges.isEmpty()) {
            throw new InvalidVersionSpecificationException(constraint, "Invalid version range " + constraint + ", expected [ or ( but got " + process);
        }
        TestVersionConstraint result = ranges.isEmpty() ? new TestVersionConstraint(this.parseVersion(constraint)) : new TestVersionConstraint((VersionRange)ranges.iterator().next());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

