/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.internal.test.util.NodeDefinition;
import org.eclipse.aether.internal.test.util.TestVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.VersionScheme;

public class DependencyGraphParser {
    private final VersionScheme versionScheme;
    private final String prefix;
    private Collection<String> substitutions;

    public DependencyGraphParser(String prefix, Collection<String> substitutions) {
        this.prefix = prefix;
        this.substitutions = substitutions;
        this.versionScheme = new TestVersionScheme();
    }

    public DependencyGraphParser(String prefix) {
        this(prefix, Collections.emptyList());
    }

    public DependencyGraphParser() {
        this("");
    }

    public DependencyNode parseLiteral(String dependencyGraph) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(dependencyGraph));
        DependencyNode node = this.parse(reader);
        reader.close();
        return node;
    }

    public DependencyNode parseResource(String resource) throws IOException {
        URL res = this.getClass().getClassLoader().getResource(this.prefix + resource);
        if (res == null) {
            throw new IOException("Could not find classpath resource " + this.prefix + resource);
        }
        return this.parse(res);
    }

    public List<DependencyNode> parseMultiResource(String resource) throws IOException {
        URL res = this.getClass().getClassLoader().getResource(this.prefix + resource);
        if (res == null) {
            throw new IOException("Could not find classpath resource " + this.prefix + resource);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(res.openStream(), StandardCharsets.UTF_8));
        ArrayList<DependencyNode> ret = new ArrayList<DependencyNode>();
        DependencyNode root = null;
        while ((root = this.parse(reader)) != null) {
            ret.add(root);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DependencyNode parse(URL resource) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));
            DependencyNode dependencyNode = this.parse(reader);
            return dependencyNode;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                    reader = null;
                }
            }
            catch (IOException iOException) {}
        }
    }

    private DependencyNode parse(BufferedReader in) throws IOException {
        Iterator<String> substitutionIterator = this.substitutions != null ? this.substitutions.iterator() : null;
        String line = null;
        DependencyNode root = null;
        DependencyNode node = null;
        int prevLevel = 0;
        HashMap<String, DependencyNode> nodes = new HashMap<String, DependencyNode>();
        LinkedList<DependencyNode> stack = new LinkedList<DependencyNode>();
        boolean isRootNode = true;
        while ((line = in.readLine()) != null) {
            if (DependencyGraphParser.isEmpty(line = DependencyGraphParser.cutComment(line))) continue;
            if (this.isEOFMarker(line)) break;
            while (line.contains("%s")) {
                if (!substitutionIterator.hasNext()) {
                    throw new IllegalStateException("not enough substitutions to fill placeholders");
                }
                line = line.replaceFirst("%s", substitutionIterator.next());
            }
            LineContext ctx = DependencyGraphParser.createContext(line);
            if (prevLevel < ctx.getLevel()) {
                stack.add(node);
            }
            while (prevLevel > ctx.getLevel()) {
                stack.removeLast();
                --prevLevel;
            }
            prevLevel = ctx.getLevel();
            if (ctx.getDefinition() != null && ctx.getDefinition().reference != null) {
                String reference = ctx.getDefinition().reference;
                DependencyNode child = (DependencyNode)nodes.get(reference);
                if (child == null) {
                    throw new IllegalStateException("undefined reference " + reference);
                }
                node.getChildren().add(child);
                continue;
            }
            node = this.build(isRootNode ? null : (DependencyNode)stack.getLast(), ctx, isRootNode);
            if (isRootNode) {
                root = node;
                isRootNode = false;
            }
            if (ctx.getDefinition() == null || ctx.getDefinition().id == null) continue;
            nodes.put(ctx.getDefinition().id, node);
        }
        return root;
    }

    private boolean isEOFMarker(String line) {
        return line.startsWith("---");
    }

    private static boolean isEmpty(String line) {
        return line == null || line.isEmpty();
    }

    private static String cutComment(String line) {
        int idx = line.indexOf(35);
        if (idx != -1) {
            line = line.substring(0, idx);
        }
        return line;
    }

    private DependencyNode build(DependencyNode parent, LineContext ctx, boolean isRoot) {
        DefaultDependencyNode node;
        NodeDefinition def = ctx.getDefinition();
        if (!isRoot && parent == null) {
            throw new IllegalStateException("dangling node: " + def);
        }
        if (ctx.getLevel() == 0 && parent != null) {
            throw new IllegalStateException("inconsistent leveling (parent for level 0?): " + def);
        }
        if (def != null) {
            DefaultArtifact artifact = new DefaultArtifact(def.coords, def.properties);
            Dependency dependency = new Dependency((Artifact)artifact, def.scope, def.optional);
            node = new DefaultDependencyNode(dependency);
            int managedBits = 0;
            if (def.premanagedScope != null) {
                managedBits |= 2;
                node.setData((Object)"premanaged.scope", (Object)def.premanagedScope);
            }
            if (def.premanagedVersion != null) {
                managedBits |= 1;
                node.setData((Object)"premanaged.version", (Object)def.premanagedVersion);
            }
            node.setManagedBits(managedBits);
            if (def.relocations != null) {
                ArrayList<DefaultArtifact> relocations = new ArrayList<DefaultArtifact>();
                for (String relocation : def.relocations) {
                    relocations.add(new DefaultArtifact(relocation));
                }
                node.setRelocations(relocations);
            }
            try {
                node.setVersion(this.versionScheme.parseVersion(artifact.getVersion()));
                node.setVersionConstraint(this.versionScheme.parseVersionConstraint(def.range != null ? def.range : artifact.getVersion()));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new IllegalArgumentException("bad version: " + e.getMessage(), e);
            }
        } else {
            node = new DefaultDependencyNode((Dependency)null);
        }
        if (parent != null) {
            parent.getChildren().add(node);
        }
        return node;
    }

    public String dump(DependencyNode root) {
        StringBuilder ret = new StringBuilder();
        ArrayList<NodeEntry> entries = new ArrayList<NodeEntry>();
        this.addNode(root, 0, entries);
        for (NodeEntry nodeEntry : entries) {
            char[] level = new char[nodeEntry.getLevel() * 3];
            Arrays.fill(level, ' ');
            if (level.length != 0) {
                level[level.length - 3] = 43;
                level[level.length - 2] = 45;
            }
            String definition = nodeEntry.getDefinition();
            ret.append(level).append(definition).append("\n");
        }
        return ret.toString();
    }

    private void addNode(DependencyNode root, int level, List<NodeEntry> entries) {
        NodeEntry entry = new NodeEntry();
        Dependency dependency = root.getDependency();
        StringBuilder defBuilder = new StringBuilder();
        if (dependency == null) {
            defBuilder.append("(null)");
        } else {
            Map properties;
            Artifact artifact = dependency.getArtifact();
            defBuilder.append(artifact.getGroupId()).append(":").append(artifact.getArtifactId()).append(":").append(artifact.getExtension()).append(":").append(artifact.getVersion());
            if (dependency.getScope() != null && !"".equals(dependency.getScope())) {
                defBuilder.append(":").append(dependency.getScope());
            }
            if ((properties = artifact.getProperties()) != null && !properties.isEmpty()) {
                for (Map.Entry prop : properties.entrySet()) {
                    defBuilder.append(";").append((String)prop.getKey()).append("=").append((String)prop.getValue());
                }
            }
        }
        entry.setDefinition(defBuilder.toString());
        entry.setLevel(level++);
        entries.add(entry);
        for (DependencyNode node : root.getChildren()) {
            this.addNode(node, level, entries);
        }
    }

    private static LineContext createContext(String line) {
        String definition;
        LineContext ctx = new LineContext();
        String[] split = line.split("- ");
        if (split.length == 1) {
            ctx.setLevel(0);
            definition = split[0];
        } else {
            ctx.setLevel((int)Math.ceil((double)split[0].length() / 3.0));
            definition = split[1];
        }
        if ("(null)".equalsIgnoreCase(definition)) {
            return ctx;
        }
        ctx.setDefinition(new NodeDefinition(definition));
        return ctx;
    }

    public Collection<String> getSubstitutions() {
        return this.substitutions;
    }

    public void setSubstitutions(Collection<String> substitutions) {
        this.substitutions = substitutions;
    }

    public void setSubstitutions(String ... substitutions) {
        this.setSubstitutions(Arrays.asList(substitutions));
    }

    static class LineContext {
        NodeDefinition definition;
        int level;

        LineContext() {
        }

        public NodeDefinition getDefinition() {
            return this.definition;
        }

        public void setDefinition(NodeDefinition definition) {
            this.definition = definition;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }
    }

    private static class NodeEntry {
        int level;
        String definition;
        Map<String, String> properties;

        private NodeEntry() {
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setDefinition(String definition) {
            this.definition = definition;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }
    }
}

