/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.aether.DefaultSessionData;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SessionData;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.transfer.TransferListener;

public final class TestRepositorySystemSession
implements RepositorySystemSession {
    private boolean readOnly;
    private boolean offline;
    private boolean ignoreArtifactDescriptorRepositories;
    private ResolutionErrorPolicy resolutionErrorPolicy;
    private ArtifactDescriptorPolicy artifactDescriptorPolicy;
    private String checksumPolicy;
    private String artifactUpdatePolicy;
    private String metadataUpdatePolicy;
    private LocalRepositoryManager localRepositoryManager;
    private WorkspaceReader workspaceReader;
    private RepositoryListener repositoryListener;
    private TransferListener transferListener;
    private Map<String, String> systemProperties;
    private Map<String, String> systemPropertiesView;
    private Map<String, String> userProperties;
    private Map<String, String> userPropertiesView;
    private Map<String, Object> configProperties;
    private Map<String, Object> configPropertiesView;
    private MirrorSelector mirrorSelector;
    private ProxySelector proxySelector;
    private AuthenticationSelector authenticationSelector;
    private ArtifactTypeRegistry artifactTypeRegistry;
    private DependencyTraverser dependencyTraverser;
    private DependencyManager dependencyManager;
    private DependencySelector dependencySelector;
    private VersionFilter versionFilter;
    private DependencyGraphTransformer dependencyGraphTransformer;
    private SessionData data;
    private RepositoryCache cache;
    private final Function<Runnable, Boolean> onSessionEndedRegistrar;

    public TestRepositorySystemSession(Consumer<Runnable> onSessionCloseConsumer) {
        this.systemProperties = new HashMap<String, String>();
        this.systemPropertiesView = Collections.unmodifiableMap(this.systemProperties);
        this.userProperties = new HashMap<String, String>();
        this.userPropertiesView = Collections.unmodifiableMap(this.userProperties);
        this.configProperties = new HashMap<String, Object>();
        this.configPropertiesView = Collections.unmodifiableMap(this.configProperties);
        this.mirrorSelector = NullMirrorSelector.INSTANCE;
        this.proxySelector = NullProxySelector.INSTANCE;
        this.authenticationSelector = NullAuthenticationSelector.INSTANCE;
        this.artifactTypeRegistry = NullArtifactTypeRegistry.INSTANCE;
        this.data = new DefaultSessionData();
        this.onSessionEndedRegistrar = h -> {
            if (onSessionCloseConsumer != null) {
                onSessionCloseConsumer.accept((Runnable)h);
                return true;
            }
            return false;
        };
    }

    public TestRepositorySystemSession(RepositorySystemSession session) {
        Objects.requireNonNull(session, "repository system session cannot be null");
        this.setOffline(session.isOffline());
        this.setIgnoreArtifactDescriptorRepositories(session.isIgnoreArtifactDescriptorRepositories());
        this.setResolutionErrorPolicy(session.getResolutionErrorPolicy());
        this.setArtifactDescriptorPolicy(session.getArtifactDescriptorPolicy());
        this.setChecksumPolicy(session.getChecksumPolicy());
        this.setUpdatePolicy(session.getUpdatePolicy());
        this.setMetadataUpdatePolicy(session.getMetadataUpdatePolicy());
        this.setLocalRepositoryManager(session.getLocalRepositoryManager());
        this.setWorkspaceReader(session.getWorkspaceReader());
        this.setRepositoryListener(session.getRepositoryListener());
        this.setTransferListener(session.getTransferListener());
        this.setSystemProperties(session.getSystemProperties());
        this.setUserProperties(session.getUserProperties());
        this.setConfigProperties(session.getConfigProperties());
        this.setMirrorSelector(session.getMirrorSelector());
        this.setProxySelector(session.getProxySelector());
        this.setAuthenticationSelector(session.getAuthenticationSelector());
        this.setArtifactTypeRegistry(session.getArtifactTypeRegistry());
        this.setDependencyTraverser(session.getDependencyTraverser());
        this.setDependencyManager(session.getDependencyManager());
        this.setDependencySelector(session.getDependencySelector());
        this.setVersionFilter(session.getVersionFilter());
        this.setDependencyGraphTransformer(session.getDependencyGraphTransformer());
        this.setData(session.getData());
        this.setCache(session.getCache());
        this.onSessionEndedRegistrar = arg_0 -> ((RepositorySystemSession)session).addOnSessionEndedHandler(arg_0);
    }

    public boolean isOffline() {
        return this.offline;
    }

    public TestRepositorySystemSession setOffline(boolean offline) {
        this.verifyStateForMutation();
        this.offline = offline;
        return this;
    }

    public boolean isIgnoreArtifactDescriptorRepositories() {
        return this.ignoreArtifactDescriptorRepositories;
    }

    public TestRepositorySystemSession setIgnoreArtifactDescriptorRepositories(boolean ignoreArtifactDescriptorRepositories) {
        this.verifyStateForMutation();
        this.ignoreArtifactDescriptorRepositories = ignoreArtifactDescriptorRepositories;
        return this;
    }

    public ResolutionErrorPolicy getResolutionErrorPolicy() {
        return this.resolutionErrorPolicy;
    }

    public TestRepositorySystemSession setResolutionErrorPolicy(ResolutionErrorPolicy resolutionErrorPolicy) {
        this.verifyStateForMutation();
        this.resolutionErrorPolicy = resolutionErrorPolicy;
        return this;
    }

    public ArtifactDescriptorPolicy getArtifactDescriptorPolicy() {
        return this.artifactDescriptorPolicy;
    }

    public TestRepositorySystemSession setArtifactDescriptorPolicy(ArtifactDescriptorPolicy artifactDescriptorPolicy) {
        this.verifyStateForMutation();
        this.artifactDescriptorPolicy = artifactDescriptorPolicy;
        return this;
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public TestRepositorySystemSession setChecksumPolicy(String checksumPolicy) {
        this.verifyStateForMutation();
        this.checksumPolicy = checksumPolicy;
        return this;
    }

    public String getUpdatePolicy() {
        return this.getArtifactUpdatePolicy();
    }

    public TestRepositorySystemSession setUpdatePolicy(String updatePolicy) {
        this.verifyStateForMutation();
        this.setArtifactUpdatePolicy(updatePolicy);
        this.setMetadataUpdatePolicy(updatePolicy);
        return this;
    }

    public String getArtifactUpdatePolicy() {
        return this.artifactUpdatePolicy;
    }

    public TestRepositorySystemSession setArtifactUpdatePolicy(String artifactUpdatePolicy) {
        this.verifyStateForMutation();
        this.artifactUpdatePolicy = artifactUpdatePolicy;
        return this;
    }

    public String getMetadataUpdatePolicy() {
        return this.metadataUpdatePolicy;
    }

    public TestRepositorySystemSession setMetadataUpdatePolicy(String metadataUpdatePolicy) {
        this.verifyStateForMutation();
        this.metadataUpdatePolicy = metadataUpdatePolicy;
        return this;
    }

    public LocalRepository getLocalRepository() {
        LocalRepositoryManager lrm = this.getLocalRepositoryManager();
        return lrm != null ? lrm.getRepository() : null;
    }

    public LocalRepositoryManager getLocalRepositoryManager() {
        return this.localRepositoryManager;
    }

    public TestRepositorySystemSession setLocalRepositoryManager(LocalRepositoryManager localRepositoryManager) {
        this.verifyStateForMutation();
        this.localRepositoryManager = localRepositoryManager;
        return this;
    }

    public WorkspaceReader getWorkspaceReader() {
        return this.workspaceReader;
    }

    public TestRepositorySystemSession setWorkspaceReader(WorkspaceReader workspaceReader) {
        this.verifyStateForMutation();
        this.workspaceReader = workspaceReader;
        return this;
    }

    public RepositoryListener getRepositoryListener() {
        return this.repositoryListener;
    }

    public TestRepositorySystemSession setRepositoryListener(RepositoryListener repositoryListener) {
        this.verifyStateForMutation();
        this.repositoryListener = repositoryListener;
        return this;
    }

    public TransferListener getTransferListener() {
        return this.transferListener;
    }

    public TestRepositorySystemSession setTransferListener(TransferListener transferListener) {
        this.verifyStateForMutation();
        this.transferListener = transferListener;
        return this;
    }

    private <T> Map<String, T> copySafe(Map<?, ?> table, Class<T> valueType) {
        HashMap<String, T> map;
        if (table == null || table.isEmpty()) {
            map = new HashMap<String, T>();
        } else {
            map = new HashMap((int)((float)table.size() / 0.75f) + 1);
            for (Map.Entry<?, ?> entry : table.entrySet()) {
                Object value;
                Object key = entry.getKey();
                if (!(key instanceof String) || !valueType.isInstance(value = entry.getValue())) continue;
                map.put(key.toString(), valueType.cast(value));
            }
        }
        return map;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemPropertiesView;
    }

    public TestRepositorySystemSession setSystemProperties(Map<?, ?> systemProperties) {
        this.verifyStateForMutation();
        this.systemProperties = this.copySafe(systemProperties, String.class);
        this.systemPropertiesView = Collections.unmodifiableMap(this.systemProperties);
        return this;
    }

    public TestRepositorySystemSession setSystemProperty(String key, String value) {
        this.verifyStateForMutation();
        if (value != null) {
            this.systemProperties.put(key, value);
        } else {
            this.systemProperties.remove(key);
        }
        return this;
    }

    public Map<String, String> getUserProperties() {
        return this.userPropertiesView;
    }

    public TestRepositorySystemSession setUserProperties(Map<?, ?> userProperties) {
        this.verifyStateForMutation();
        this.userProperties = this.copySafe(userProperties, String.class);
        this.userPropertiesView = Collections.unmodifiableMap(this.userProperties);
        return this;
    }

    public TestRepositorySystemSession setUserProperty(String key, String value) {
        this.verifyStateForMutation();
        if (value != null) {
            this.userProperties.put(key, value);
        } else {
            this.userProperties.remove(key);
        }
        return this;
    }

    public Map<String, Object> getConfigProperties() {
        return this.configPropertiesView;
    }

    public TestRepositorySystemSession setConfigProperties(Map<?, ?> configProperties) {
        this.verifyStateForMutation();
        this.configProperties = this.copySafe(configProperties, Object.class);
        this.configPropertiesView = Collections.unmodifiableMap(this.configProperties);
        return this;
    }

    public TestRepositorySystemSession setConfigProperty(String key, Object value) {
        this.verifyStateForMutation();
        if (value != null) {
            this.configProperties.put(key, value);
        } else {
            this.configProperties.remove(key);
        }
        return this;
    }

    public MirrorSelector getMirrorSelector() {
        return this.mirrorSelector;
    }

    public TestRepositorySystemSession setMirrorSelector(MirrorSelector mirrorSelector) {
        this.verifyStateForMutation();
        this.mirrorSelector = mirrorSelector;
        if (this.mirrorSelector == null) {
            this.mirrorSelector = NullMirrorSelector.INSTANCE;
        }
        return this;
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public TestRepositorySystemSession setProxySelector(ProxySelector proxySelector) {
        this.verifyStateForMutation();
        this.proxySelector = proxySelector;
        if (this.proxySelector == null) {
            this.proxySelector = NullProxySelector.INSTANCE;
        }
        return this;
    }

    public AuthenticationSelector getAuthenticationSelector() {
        return this.authenticationSelector;
    }

    public TestRepositorySystemSession setAuthenticationSelector(AuthenticationSelector authenticationSelector) {
        this.verifyStateForMutation();
        this.authenticationSelector = authenticationSelector;
        if (this.authenticationSelector == null) {
            this.authenticationSelector = NullAuthenticationSelector.INSTANCE;
        }
        return this;
    }

    public ArtifactTypeRegistry getArtifactTypeRegistry() {
        return this.artifactTypeRegistry;
    }

    public TestRepositorySystemSession setArtifactTypeRegistry(ArtifactTypeRegistry artifactTypeRegistry) {
        this.verifyStateForMutation();
        this.artifactTypeRegistry = artifactTypeRegistry;
        if (this.artifactTypeRegistry == null) {
            this.artifactTypeRegistry = NullArtifactTypeRegistry.INSTANCE;
        }
        return this;
    }

    public DependencyTraverser getDependencyTraverser() {
        return this.dependencyTraverser;
    }

    public TestRepositorySystemSession setDependencyTraverser(DependencyTraverser dependencyTraverser) {
        this.verifyStateForMutation();
        this.dependencyTraverser = dependencyTraverser;
        return this;
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public TestRepositorySystemSession setDependencyManager(DependencyManager dependencyManager) {
        this.verifyStateForMutation();
        this.dependencyManager = dependencyManager;
        return this;
    }

    public DependencySelector getDependencySelector() {
        return this.dependencySelector;
    }

    public TestRepositorySystemSession setDependencySelector(DependencySelector dependencySelector) {
        this.verifyStateForMutation();
        this.dependencySelector = dependencySelector;
        return this;
    }

    public VersionFilter getVersionFilter() {
        return this.versionFilter;
    }

    public TestRepositorySystemSession setVersionFilter(VersionFilter versionFilter) {
        this.verifyStateForMutation();
        this.versionFilter = versionFilter;
        return this;
    }

    public DependencyGraphTransformer getDependencyGraphTransformer() {
        return this.dependencyGraphTransformer;
    }

    public TestRepositorySystemSession setDependencyGraphTransformer(DependencyGraphTransformer dependencyGraphTransformer) {
        this.verifyStateForMutation();
        this.dependencyGraphTransformer = dependencyGraphTransformer;
        return this;
    }

    public SessionData getData() {
        return this.data;
    }

    public TestRepositorySystemSession setData(SessionData data) {
        this.verifyStateForMutation();
        this.data = data;
        if (this.data == null) {
            this.data = new DefaultSessionData();
        }
        return this;
    }

    public RepositoryCache getCache() {
        return this.cache;
    }

    public TestRepositorySystemSession setCache(RepositoryCache cache) {
        this.verifyStateForMutation();
        this.cache = cache;
        return this;
    }

    public boolean addOnSessionEndedHandler(Runnable handler) {
        return this.onSessionEndedRegistrar.apply(handler);
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    private void verifyStateForMutation() {
        if (this.readOnly) {
            throw new IllegalStateException("repository system session is read-only");
        }
    }

    static class NullMirrorSelector
    implements MirrorSelector {
        public static final MirrorSelector INSTANCE = new NullMirrorSelector();

        NullMirrorSelector() {
        }

        public RemoteRepository getMirror(RemoteRepository repository) {
            Objects.requireNonNull(repository, "repository cannot be null");
            return null;
        }
    }

    static class NullProxySelector
    implements ProxySelector {
        public static final ProxySelector INSTANCE = new NullProxySelector();

        NullProxySelector() {
        }

        public Proxy getProxy(RemoteRepository repository) {
            Objects.requireNonNull(repository, "repository cannot be null");
            return repository.getProxy();
        }
    }

    static class NullAuthenticationSelector
    implements AuthenticationSelector {
        public static final AuthenticationSelector INSTANCE = new NullAuthenticationSelector();

        NullAuthenticationSelector() {
        }

        public Authentication getAuthentication(RemoteRepository repository) {
            Objects.requireNonNull(repository, "repository cannot be null");
            return repository.getAuthentication();
        }
    }

    static final class NullArtifactTypeRegistry
    implements ArtifactTypeRegistry {
        public static final ArtifactTypeRegistry INSTANCE = new NullArtifactTypeRegistry();

        NullArtifactTypeRegistry() {
        }

        public ArtifactType get(String typeId) {
            return null;
        }
    }
}

