/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util;

import java.util.Objects;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.test.util.ArtifactDescription;
import org.eclipse.aether.internal.test.util.IniArtifactDataReader;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public class IniArtifactDescriptorReader {
    private final IniArtifactDataReader reader;

    public IniArtifactDescriptorReader(String prefix) {
        this.reader = new IniArtifactDataReader(prefix);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
        ArtifactDescriptorResult result = new ArtifactDescriptorResult(request);
        Artifact artifact = request.getArtifact();
        while (true) {
            String resourceName = String.format("%s_%s_%s.ini", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            try {
                ArtifactDescription data = this.reader.parse(resourceName);
                if (data.getRelocation() == null) {
                    result.setArtifact(artifact);
                    result.setDependencies(data.getDependencies());
                    result.setManagedDependencies(data.getManagedDependencies());
                    result.setRepositories(data.getRepositories());
                    return result;
                }
                result.addRelocation(artifact);
                artifact = data.getRelocation();
            }
            catch (Exception e) {
                throw new ArtifactDescriptorException(result, e.getMessage(), (Throwable)e);
            }
        }
    }
}

