/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.UUID;

public class TestFileUtils {
    private static final File TMP = new File(System.getProperty("java.io.tmpdir"), "aether-" + UUID.randomUUID().toString().substring(0, 8));

    private TestFileUtils() {
    }

    public static void deleteTempFiles() throws IOException {
        TestFileUtils.deleteFile(TMP);
    }

    public static void deleteFile(File file) throws IOException {
        if (file == null) {
            return;
        }
        ArrayList<File> undeletables = new ArrayList<File>();
        TestFileUtils.delete(file, undeletables);
        if (!undeletables.isEmpty()) {
            throw new IOException("Failed to delete " + undeletables);
        }
    }

    private static void delete(File file, Collection<File> undeletables) {
        String[] children = file.list();
        if (children != null) {
            for (String child : children) {
                TestFileUtils.delete(new File(file, child), undeletables);
            }
        }
        if (!TestFileUtils.del(file)) {
            undeletables.add(file.getAbsoluteFile());
        }
    }

    private static boolean del(File file) {
        for (int i = 0; i < 10; ++i) {
            if (!file.delete() && file.exists()) continue;
            return true;
        }
        return false;
    }

    public static boolean mkdirs(File directory) {
        if (directory == null) {
            return false;
        }
        if (directory.exists()) {
            return false;
        }
        if (directory.mkdir()) {
            return true;
        }
        File canonDir = null;
        try {
            canonDir = directory.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        File parentDir = canonDir.getParentFile();
        return parentDir != null && (TestFileUtils.mkdirs(parentDir) || parentDir.exists()) && canonDir.mkdir();
    }

    public static File createTempFile(String contents) throws IOException {
        return TestFileUtils.createTempFile(contents.getBytes(StandardCharsets.UTF_8), 1);
    }

    public static File createTempFile(byte[] pattern, int repeat) throws IOException {
        TestFileUtils.mkdirs(TMP);
        File tmpFile = File.createTempFile("tmpfile-", ".data", TMP);
        TestFileUtils.writeBytes(tmpFile, pattern, repeat);
        return tmpFile;
    }

    public static File createTempDir() throws IOException {
        return TestFileUtils.createTempDir("");
    }

    public static File createTempDir(String suffix) throws IOException {
        TestFileUtils.mkdirs(TMP);
        File tmpFile = File.createTempFile("tmpdir-", suffix, TMP);
        TestFileUtils.deleteFile(tmpFile);
        TestFileUtils.mkdirs(tmpFile);
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static long copyFile(File source, File target) throws IOException {
        long total = 0L;
        FileInputStream fis = null;
        OutputStream fos = null;
        try {
            int bytes;
            fis = new FileInputStream(source);
            TestFileUtils.mkdirs(target.getParentFile());
            fos = new BufferedOutputStream(new FileOutputStream(target));
            byte[] buffer = new byte[32768];
            while ((bytes = fis.read(buffer)) >= 0) {
                fos.write(buffer, 0, bytes);
                total += (long)bytes;
            }
            fos.close();
            fos = null;
            fis.close();
            fis = null;
        }
        finally {
            block29: {
                block28: {
                    if (fos == null) break block28;
                    fos.close();
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    break block29;
                }
                catch (IOException e) {}
                break block29;
                catch (IOException e) {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException e2) {}
                    catch (Throwable throwable) {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (IOException e3) {}
                        throw throwable;
                    }
                }
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(File file) throws IOException {
        RandomAccessFile in = null;
        try {
            in = new RandomAccessFile(file, "r");
            byte[] actual = new byte[(int)in.length()];
            in.readFully(actual);
            in.close();
            in = null;
            byte[] byArray = actual;
            return byArray;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytes(File file, byte[] pattern, int repeat) throws IOException {
        file.deleteOnExit();
        file.getParentFile().mkdirs();
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            for (int i = 0; i < repeat; ++i) {
                out.write(pattern);
            }
            out.close();
            out = null;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static String readString(File file) throws IOException {
        byte[] content = TestFileUtils.readBytes(file);
        return new String(content, StandardCharsets.UTF_8);
    }

    public static void writeString(File file, String content) throws IOException {
        TestFileUtils.writeBytes(file, content.getBytes(StandardCharsets.UTF_8), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readProps(File file, Properties props) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            props.load(fis);
            fis.close();
            fis = null;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProps(File file, Properties props) throws IOException {
        file.getParentFile().mkdirs();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            props.store(fos, "aether-test");
            fos.close();
            fos = null;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    TestFileUtils.deleteFile(TMP);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

