/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.aether.spi.io.FileProcessor;

public class TestFileProcessor
implements FileProcessor {
    public boolean mkdirs(File directory) {
        if (directory == null) {
            return false;
        }
        if (directory.exists()) {
            return false;
        }
        if (directory.mkdir()) {
            return true;
        }
        File canonDir = null;
        try {
            canonDir = directory.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        File parentDir = canonDir.getParentFile();
        return parentDir != null && (this.mkdirs(parentDir) || parentDir.exists()) && canonDir.mkdir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, String data) throws IOException {
        this.mkdirs(file.getParentFile());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            if (data != null) {
                fos.write(data.getBytes(StandardCharsets.UTF_8));
            }
            fos.close();
            fos = null;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File target, InputStream source) throws IOException {
        this.mkdirs(target.getAbsoluteFile().getParentFile());
        OutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new FileOutputStream(target));
            this.copy(fos, source, null);
            fos.close();
            fos = null;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void copy(File source, File target) throws IOException {
        this.copy(source, target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public long copy(File source, File target, FileProcessor.ProgressListener listener) throws IOException {
        long total = 0L;
        FileInputStream fis = null;
        OutputStream fos = null;
        try {
            fis = new FileInputStream(source);
            this.mkdirs(target.getAbsoluteFile().getParentFile());
            fos = new BufferedOutputStream(new FileOutputStream(target));
            total = this.copy(fos, fis, listener);
            fos.close();
            fos = null;
            ((InputStream)fis).close();
            fis = null;
        }
        finally {
            block28: {
                block27: {
                    if (fos == null) break block27;
                    fos.close();
                }
                try {
                    if (fis != null) {
                        ((InputStream)fis).close();
                    }
                    break block28;
                }
                catch (IOException e) {}
                break block28;
                catch (IOException e) {
                    try {
                        if (fis != null) {
                            ((InputStream)fis).close();
                        }
                    }
                    catch (IOException e2) {}
                    catch (Throwable throwable) {
                        try {
                            if (fis != null) {
                                ((InputStream)fis).close();
                            }
                        }
                        catch (IOException e3) {}
                        throw throwable;
                    }
                }
            }
        }
        return total;
    }

    private long copy(OutputStream os, InputStream is, FileProcessor.ProgressListener listener) throws IOException {
        int bytes;
        long total = 0L;
        ByteBuffer buffer = ByteBuffer.allocate(32768);
        byte[] array = buffer.array();
        while ((bytes = is.read(array)) >= 0) {
            os.write(array, 0, bytes);
            total += (long)bytes;
            if (listener == null || bytes <= 0) continue;
            try {
                buffer.rewind();
                buffer.limit(bytes);
                listener.progressed(buffer);
            }
            catch (Exception e) {}
        }
        return total;
    }

    public void move(File source, File target) throws IOException {
        target.delete();
        if (!source.renameTo(target)) {
            this.copy(source, target);
            target.setLastModified(source.lastModified());
            source.delete();
        }
    }
}

