/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util;

import java.util.Objects;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.eclipse.aether.version.VersionRange;

final class TestVersionConstraint
implements VersionConstraint {
    private final VersionRange range;
    private final Version version;

    TestVersionConstraint(VersionRange range) {
        this.range = Objects.requireNonNull(range, "version range cannot be null");
        this.version = null;
    }

    TestVersionConstraint(Version version) {
        this.version = Objects.requireNonNull(version, "version cannot be null");
        this.range = null;
    }

    public VersionRange getRange() {
        return this.range;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean containsVersion(Version version) {
        if (this.range == null) {
            return version.equals(this.version);
        }
        return this.range.containsVersion(version);
    }

    public String toString() {
        return String.valueOf(this.range == null ? this.version : this.range);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        TestVersionConstraint that = (TestVersionConstraint)obj;
        return TestVersionConstraint.eq(this.range, that.range) && TestVersionConstraint.eq(this.version, that.getVersion());
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + TestVersionConstraint.hash(this.getRange());
        hash = hash * 31 + TestVersionConstraint.hash(this.getVersion());
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }
}

