/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.internal.test.util.ArtifactDefinition;
import org.eclipse.aether.internal.test.util.ArtifactDescription;
import org.eclipse.aether.repository.RemoteRepository;

class IniArtifactDataReader {
    private String prefix = "";

    IniArtifactDataReader() {
        this("");
    }

    IniArtifactDataReader(String prefix) {
        this.prefix = prefix;
    }

    public ArtifactDescription parse(String resource) throws IOException {
        URL res = this.getClass().getClassLoader().getResource(this.prefix + resource);
        if (res == null) {
            throw new IOException("cannot find resource: " + resource);
        }
        return this.parse(res);
    }

    public ArtifactDescription parse(URL res) throws IOException {
        return this.parse(new InputStreamReader(res.openStream(), StandardCharsets.UTF_8));
    }

    public ArtifactDescription parseLiteral(String description) throws IOException {
        StringReader reader = new StringReader(description);
        return this.parse(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArtifactDescription parse(Reader reader) throws IOException {
        String line = null;
        State state = State.NONE;
        HashMap sections = new HashMap();
        BufferedReader in = null;
        try {
            in = new BufferedReader(reader);
            while ((line = in.readLine()) != null) {
                if (IniArtifactDataReader.isEmpty(line = IniArtifactDataReader.cutComment(line))) continue;
                if (line.startsWith("[")) {
                    try {
                        String name = line.substring(1, line.length() - 1);
                        name = name.replace("-", "").toUpperCase(Locale.ENGLISH);
                        state = State.valueOf(name);
                        sections.put(state, new ArrayList());
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new IOException("unknown section: " + line);
                    }
                }
                List lines = (List)sections.get((Object)state);
                if (lines == null) {
                    throw new IOException("missing section: " + line);
                }
                lines.add(line.trim());
            }
            in.close();
            in = null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException lines) {}
        }
        Artifact relocation = this.relocation((List)sections.get((Object)State.RELOCATION));
        List<Dependency> dependencies = this.dependencies((List)sections.get((Object)State.DEPENDENCIES), false);
        List<Dependency> managedDependencies = this.dependencies((List)sections.get((Object)State.MANAGEDDEPENDENCIES), true);
        List<RemoteRepository> repositories = this.repositories((List)sections.get((Object)State.REPOSITORIES));
        ArtifactDescription description = new ArtifactDescription(relocation, dependencies, managedDependencies, repositories);
        return description;
    }

    private List<RemoteRepository> repositories(List<String> list) {
        ArrayList<RemoteRepository> ret = new ArrayList<RemoteRepository>();
        if (list == null) {
            return ret;
        }
        for (String coords : list) {
            String[] split = coords.split(":", 3);
            String id = split[0];
            String type = split[1];
            String url = split[2];
            ret.add(new RemoteRepository.Builder(id, type, url).build());
        }
        return ret;
    }

    private List<Dependency> dependencies(List<String> list, boolean managed) {
        ArrayList<Dependency> ret = new ArrayList<Dependency>();
        if (list == null) {
            return ret;
        }
        ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
        Boolean optional = null;
        DefaultArtifact artifact = null;
        String scope = null;
        for (String coords : list) {
            if (coords.startsWith("-")) {
                coords = coords.substring(1);
                String[] split = coords.split(":");
                exclusions.add(new Exclusion(split[0], split[1], "*", "*"));
                continue;
            }
            if (artifact != null) {
                Dependency dep = new Dependency(artifact, scope, optional, exclusions);
                ret.add(dep);
                exclusions = new ArrayList();
            }
            ArtifactDefinition def = new ArtifactDefinition(coords);
            optional = managed ? def.getOptional() : Boolean.valueOf(Boolean.TRUE.equals(def.getOptional()));
            scope = "".equals(def.getScope()) && !managed ? "compile" : def.getScope();
            artifact = new DefaultArtifact(def.getGroupId(), def.getArtifactId(), "", def.getExtension(), def.getVersion());
        }
        if (artifact != null) {
            Dependency dep = new Dependency(artifact, scope, optional, exclusions);
            ret.add(dep);
        }
        return ret;
    }

    private Artifact relocation(List<String> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        String coords = list.get(0);
        ArtifactDefinition def = new ArtifactDefinition(coords);
        return new DefaultArtifact(def.getGroupId(), def.getArtifactId(), "", def.getExtension(), def.getVersion());
    }

    private static boolean isEmpty(String line) {
        return line == null || line.length() == 0;
    }

    private static String cutComment(String line) {
        int idx = line.indexOf(35);
        if (idx != -1) {
            line = line.substring(0, idx);
        }
        return line;
    }

    static class Definition {
        private String groupId;
        private String artifactId;
        private String extension;
        private String version;
        private String scope = "";
        private String definition;
        private String id = null;
        private String reference = null;
        private boolean optional = false;

        Definition(String def) {
            this.definition = def.trim();
            if (this.definition.startsWith("(")) {
                int idx = this.definition.indexOf(41);
                this.id = this.definition.substring(1, idx);
                this.definition = this.definition.substring(idx + 1);
            } else if (this.definition.startsWith("^")) {
                this.reference = this.definition.substring(1);
                return;
            }
            String[] split = this.definition.split(":");
            if (split.length < 4) {
                throw new IllegalArgumentException("Need definition like 'gid:aid:ext:ver[:scope]', but was: " + this.definition);
            }
            this.groupId = split[0];
            this.artifactId = split[1];
            this.extension = split[2];
            this.version = split[3];
            if (split.length > 4) {
                this.scope = split[4];
            }
            if (split.length > 5 && "true".equalsIgnoreCase(split[5])) {
                this.optional = true;
            }
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getType() {
            return this.extension;
        }

        public String getVersion() {
            return this.version;
        }

        public String getScope() {
            return this.scope;
        }

        public String toString() {
            return this.definition;
        }

        public String getId() {
            return this.id;
        }

        public String getReference() {
            return this.reference;
        }

        public boolean isReference() {
            return this.reference != null;
        }

        public boolean hasId() {
            return this.id != null;
        }

        public boolean isOptional() {
            return this.optional;
        }
    }

    private static enum State {
        NONE,
        RELOCATION,
        DEPENDENCIES,
        MANAGEDDEPENDENCIES,
        REPOSITORIES;

    }
}

